/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.nativeimpl.serviceendpoint;

import io.grpc.ServerBuilder;
import io.netty.handler.ssl.SslContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BlockingNativeCallableUnit;
import org.ballerinalang.config.ConfigRegistry;
import org.ballerinalang.connector.api.BLangConnectorSPIUtil;
import org.ballerinalang.connector.api.BallerinaConnectorException;
import org.ballerinalang.connector.api.Struct;
import org.ballerinalang.connector.api.Value;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.net.grpc.GrpcServicesBuilder;
import org.ballerinalang.net.grpc.MessageUtils;
import org.ballerinalang.net.grpc.ssl.SSLHandlerFactory;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.wso2.transport.http.netty.config.ListenerConfiguration;
import org.wso2.transport.http.netty.config.Parameter;

@BallerinaFunction(orgName="ballerina", packageName="grpc", functionName="init", receiver=@Receiver(type=TypeKind.STRUCT, structType="Listener", structPackage="ballerina.grpc"), args={@Argument(name="config", type=TypeKind.STRUCT, structType="ServiceEndpointConfiguration", structPackage="ballerina.grpc")}, isPublic=true)
public class Init
extends BlockingNativeCallableUnit {
    private static final ConfigRegistry configRegistry = ConfigRegistry.getInstance();

    public void execute(Context context) {
        try {
            ServerBuilder serverBuilder;
            Struct serviceEndpoint = BLangConnectorSPIUtil.getConnectorEndpointStruct((Context)context);
            BStruct endpointConfigStruct = (BStruct)context.getRefArgument(1);
            Struct serviceEndpointConfig = BLangConnectorSPIUtil.toStruct((BStruct)endpointConfigStruct);
            ListenerConfiguration configuration = this.getListenerConfig(serviceEndpointConfig);
            if (configuration.getSSLConfig() != null) {
                SslContext sslCtx = new SSLHandlerFactory(configuration.getSSLConfig()).createHttp2TLSContextForServer();
                serverBuilder = GrpcServicesBuilder.initService(configuration, sslCtx);
            } else {
                serverBuilder = GrpcServicesBuilder.initService(configuration, null);
            }
            serviceEndpoint.addNativeData("SERVICE_BUILDER", (Object)serverBuilder);
            context.setReturnValues(new BValue[0]);
        }
        catch (Throwable throwable) {
            BStruct err = Init.getConnectorError(context, throwable);
            context.setError(err);
        }
    }

    private static BStruct getConnectorError(Context context, Throwable throwable) {
        return MessageUtils.getConnectorError(context, throwable);
    }

    private ListenerConfiguration getListenerConfig(Struct endpointConfig) {
        String host = endpointConfig.getStringField("host");
        long port = endpointConfig.getIntField("port");
        Struct sslConfig = endpointConfig.getStructField("secureSocket");
        ListenerConfiguration listenerConfiguration = new ListenerConfiguration();
        if (host == null || host.trim().isEmpty()) {
            listenerConfiguration.setHost(configRegistry.getConfigOrDefault("b7a.http.host", "0.0.0.0"));
        } else {
            listenerConfiguration.setHost(host);
        }
        if (port == 9090L && configRegistry.contains("b7a.http.port")) {
            port = Long.parseLong(configRegistry.getAsString("b7a.http.port"));
        }
        listenerConfiguration.setPort(Math.toIntExact(port));
        if (sslConfig != null) {
            return this.setSslConfig(sslConfig, listenerConfiguration);
        }
        listenerConfiguration.setServerHeader(this.getServerName());
        return listenerConfiguration;
    }

    private ListenerConfiguration setSslConfig(Struct sslConfig, ListenerConfiguration listenerConfiguration) {
        long cacheValidationPeriod;
        long cacheSize;
        List<Value> ciphersValueList;
        Parameter serverParameters;
        listenerConfiguration.setScheme("https");
        Struct trustStore = sslConfig.getStructField("trustStore");
        Struct keyStore = sslConfig.getStructField("keyStore");
        Struct protocols = sslConfig.getStructField("protocol");
        Struct validateCert = sslConfig.getStructField("certValidation");
        Struct ocspStapling = sslConfig.getStructField("ocspStapling");
        if (keyStore != null) {
            String keyStoreFile = keyStore.getStringField("path");
            String keyStorePassword = keyStore.getStringField("password");
            if (StringUtils.isBlank((CharSequence)keyStoreFile)) {
                throw new BallerinaConnectorException("Keystore location must be provided for secure connection");
            }
            if (StringUtils.isBlank((CharSequence)keyStorePassword)) {
                throw new BallerinaConnectorException("Keystore password value must be provided for secure connection");
            }
            listenerConfiguration.setKeyStoreFile(keyStoreFile);
            listenerConfiguration.setKeyStorePass(keyStorePassword);
        }
        String sslVerifyClient = sslConfig.getStringField("sslVerifyClient");
        listenerConfiguration.setVerifyClient(sslVerifyClient);
        if (trustStore != null) {
            String trustStoreFile = trustStore.getStringField("path");
            String trustStorePassword = trustStore.getStringField("password");
            if (StringUtils.isBlank((CharSequence)trustStoreFile) && StringUtils.isNotBlank((CharSequence)sslVerifyClient)) {
                throw new BallerinaException("Truststore location must be provided to enable Mutual SSL");
            }
            if (StringUtils.isBlank((CharSequence)trustStorePassword) && StringUtils.isNotBlank((CharSequence)sslVerifyClient)) {
                throw new BallerinaException("Truststore password value must be provided to enable Mutual SSL");
            }
            listenerConfiguration.setTrustStoreFile(trustStoreFile);
            listenerConfiguration.setTrustStorePass(trustStorePassword);
        }
        ArrayList<Parameter> serverParamList = new ArrayList<Parameter>();
        if (protocols != null) {
            String sslProtocol;
            List<Value> sslEnabledProtocolsValueList = Arrays.asList(protocols.getArrayField("versions"));
            if (sslEnabledProtocolsValueList.size() > 0) {
                String sslEnabledProtocols = sslEnabledProtocolsValueList.stream().map(Value::getStringValue).collect(Collectors.joining(",", "", ""));
                serverParameters = new Parameter("sslEnabledProtocols", sslEnabledProtocols);
                serverParamList.add(serverParameters);
            }
            if (StringUtils.isNotBlank((CharSequence)(sslProtocol = protocols.getStringField("name")))) {
                listenerConfiguration.setSSLProtocol(sslProtocol);
            }
        }
        if ((ciphersValueList = Arrays.asList(sslConfig.getArrayField("ciphers"))).size() > 0) {
            String ciphers = ciphersValueList.stream().map(Value::getStringValue).collect(Collectors.joining(",", "", ""));
            serverParameters = new Parameter("ciphers", ciphers);
            serverParamList.add(serverParameters);
        }
        if (validateCert != null) {
            boolean validateCertificateEnabled = validateCert.getBooleanField("enable");
            cacheSize = validateCert.getIntField("cacheSize");
            cacheValidationPeriod = validateCert.getIntField("cacheValidityPeriod");
            listenerConfiguration.setValidateCertEnabled(validateCertificateEnabled);
            if (validateCertificateEnabled) {
                if (cacheSize != 0L) {
                    listenerConfiguration.setCacheSize(Math.toIntExact(cacheSize));
                }
                if (cacheValidationPeriod != 0L) {
                    listenerConfiguration.setCacheValidityPeriod(Math.toIntExact(cacheValidationPeriod));
                }
            }
        }
        if (ocspStapling != null) {
            boolean ocspStaplingEnabled = ocspStapling.getBooleanField("enable");
            listenerConfiguration.setOcspStaplingEnabled(ocspStaplingEnabled);
            cacheSize = ocspStapling.getIntField("cacheSize");
            cacheValidationPeriod = ocspStapling.getIntField("cacheValidityPeriod");
            listenerConfiguration.setValidateCertEnabled(ocspStaplingEnabled);
            if (ocspStaplingEnabled) {
                if (cacheSize != 0L) {
                    listenerConfiguration.setCacheSize(Math.toIntExact(cacheSize));
                }
                if (cacheValidationPeriod != 0L) {
                    listenerConfiguration.setCacheValidityPeriod(Math.toIntExact(cacheValidationPeriod));
                }
            }
        }
        listenerConfiguration.setTLSStoreType("PKCS12");
        String serverEnableSessionCreation = String.valueOf(sslConfig.getBooleanField("shareSession"));
        Parameter enableSessionCreationParam = new Parameter("shareSession", serverEnableSessionCreation);
        serverParamList.add(enableSessionCreationParam);
        if (!serverParamList.isEmpty()) {
            listenerConfiguration.setParameters(serverParamList);
        }
        listenerConfiguration.setId(Init.getListenerInterface(listenerConfiguration.getHost(), listenerConfiguration.getPort()));
        return listenerConfiguration;
    }

    public static String getListenerInterface(String host, int port) {
        host = host != null ? host : "0.0.0.0";
        return host + ":" + port;
    }

    private String getServerName() {
        String version = System.getProperty("ballerina.version");
        String userAgent = version != null ? "ballerina/" + version : "ballerina";
        return userAgent;
    }
}

