/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.stubs;

import io.grpc.Metadata;
import io.grpc.stub.StreamObserver;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.ballerinalang.bre.bvm.CallableUnitCallback;
import org.ballerinalang.connector.api.Executor;
import org.ballerinalang.connector.api.ParamDetail;
import org.ballerinalang.connector.api.Resource;
import org.ballerinalang.connector.api.Service;
import org.ballerinalang.model.types.BStructType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.net.grpc.GrpcCallableUnitCallBack;
import org.ballerinalang.net.grpc.Message;
import org.ballerinalang.net.grpc.MessageHeaders;
import org.ballerinalang.net.grpc.MessageUtils;
import org.ballerinalang.net.grpc.exception.GrpcClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultStreamObserver
implements StreamObserver<Message> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultStreamObserver.class);
    private Map<String, Resource> resourceMap = new HashMap<String, Resource>();
    private AtomicReference<Metadata> headerCapture;

    public DefaultStreamObserver(Service callbackService, AtomicReference<Metadata> headerCapture) throws GrpcClientException {
        if (callbackService == null) {
            throw new GrpcClientException("Error while building the connection. Listener Service does not exist");
        }
        for (Resource resource : callbackService.getResources()) {
            this.resourceMap.put(resource.getName(), resource);
        }
        this.headerCapture = headerCapture;
    }

    public void onNext(Message value) {
        BValue requestParam;
        Resource resource = this.resourceMap.get("onMessage");
        if (resource == null) {
            String message = "Error in listener service definition. onNext resource does not exists";
            LOG.error(message);
            throw new RuntimeException(message);
        }
        List paramDetails = resource.getParamDetails();
        BValue[] signatureParams = new BValue[paramDetails.size()];
        BStruct headerStruct = MessageUtils.getHeaderStruct(resource);
        Metadata respMetadata = this.headerCapture.get();
        if (headerStruct != null && respMetadata != null) {
            headerStruct.addNativeData("Metadata", (Object)new MessageHeaders(respMetadata));
        }
        if ((requestParam = this.getRequestParameter(resource, value, headerStruct != null)) != null) {
            signatureParams[0] = requestParam;
        }
        if (headerStruct != null) {
            signatureParams[signatureParams.length - 1] = headerStruct;
        }
        GrpcCallableUnitCallBack callback = new GrpcCallableUnitCallBack(null);
        Executor.submit((Resource)resource, (CallableUnitCallback)callback, null, null, (BValue[])signatureParams);
    }

    public void onError(Throwable t) {
        Resource onError = this.resourceMap.get("onError");
        if (onError == null) {
            String message = "Error in listener service definition. onError resource does not exists";
            LOG.error(message);
            throw new RuntimeException(message);
        }
        List paramDetails = onError.getParamDetails();
        BValue[] signatureParams = new BValue[paramDetails.size()];
        BType errorType = ((ParamDetail)paramDetails.get(0)).getVarType();
        BStruct errorStruct = MessageUtils.getConnectorError((BStructType)errorType, t);
        signatureParams[0] = errorStruct;
        BStruct headerStruct = MessageUtils.getHeaderStruct(onError);
        Metadata respMetadata = this.headerCapture.get();
        if (headerStruct != null && respMetadata != null) {
            headerStruct.addNativeData("Metadata", (Object)new MessageHeaders(respMetadata));
        }
        if (headerStruct != null && signatureParams.length == 2) {
            signatureParams[1] = headerStruct;
        }
        GrpcCallableUnitCallBack callback = new GrpcCallableUnitCallBack(null);
        Executor.submit((Resource)onError, (CallableUnitCallback)callback, null, null, (BValue[])signatureParams);
    }

    public void onCompleted() {
        Resource onCompleted = this.resourceMap.get("onComplete");
        if (onCompleted == null) {
            String message = "Error in listener service definition. onCompleted resource does not exists";
            LOG.error(message);
            throw new RuntimeException(message);
        }
        List paramDetails = onCompleted.getParamDetails();
        BValue[] signatureParams = new BValue[paramDetails.size()];
        BStruct headerStruct = MessageUtils.getHeaderStruct(onCompleted);
        Metadata respMetadata = this.headerCapture.get();
        if (headerStruct != null && respMetadata != null) {
            headerStruct.addNativeData("Metadata", (Object)new MessageHeaders(respMetadata));
        }
        if (headerStruct != null && signatureParams.length == 1) {
            signatureParams[0] = headerStruct;
        }
        GrpcCallableUnitCallBack callback = new GrpcCallableUnitCallBack(null);
        Executor.submit((Resource)onCompleted, (CallableUnitCallback)callback, null, null, (BValue[])signatureParams);
    }

    private BValue getRequestParameter(Resource resource, Message requestMessage, boolean isHeaderRequired) {
        if (resource == null || resource.getParamDetails() == null || resource.getParamDetails().size() > 2) {
            throw new RuntimeException("Invalid resource input arguments. arguments must not be greater than two");
        }
        List paramDetails = resource.getParamDetails();
        if (isHeaderRequired && paramDetails.size() == 2 || !isHeaderRequired && paramDetails.size() == 1) {
            BType requestType = ((ParamDetail)resource.getParamDetails().get(0)).getVarType();
            String requestName = ((ParamDetail)resource.getParamDetails().get(0)).getVarName();
            return MessageUtils.generateRequestStruct(requestMessage, MessageUtils.getProgramFile(resource), requestName, requestType);
        }
        return null;
    }
}

