/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc;

import io.grpc.Context;
import io.grpc.Metadata;
import java.util.Set;

public class MessageHeaders {
    public static final String METADATA_KEY = "Metadata";
    public static final Context.Key<MessageHeaders> DATA_KEY = Context.key((String)"Metadata");
    private Metadata contextMetadata;

    public static Context initialize(Context context) {
        if (context == null) {
            throw new RuntimeException("Context instance provided is null.");
        }
        if (DATA_KEY.get(context) != null) {
            throw new IllegalStateException("MessageHeaders has already been created in the scope of the current context");
        }
        return context.withValue(DATA_KEY, (Object)new MessageHeaders());
    }

    public Metadata getMessageMetadata() {
        return this.contextMetadata;
    }

    public static MessageHeaders current() {
        if (DATA_KEY.get() == null) {
            throw new IllegalStateException("MessageHeaders has not yet been created in the scope of the current context");
        }
        return (MessageHeaders)DATA_KEY.get();
    }

    public static boolean isPresent() {
        return DATA_KEY.get() != null;
    }

    public MessageHeaders() {
        this.contextMetadata = new Metadata();
    }

    public MessageHeaders(MessageHeaders other) {
        this();
        this.contextMetadata.merge(other.contextMetadata);
    }

    public MessageHeaders(Metadata metadata) {
        this.contextMetadata = metadata;
    }

    public Context fork(Context context) {
        return context.withValue(DATA_KEY, (Object)new MessageHeaders(this));
    }

    public boolean containsKey(Metadata.Key<?> key) {
        return this.contextMetadata.containsKey(key);
    }

    public <T> void discardAll(Metadata.Key<T> key) {
        this.contextMetadata.discardAll(key);
    }

    public <T> T get(Metadata.Key<T> key) {
        return (T)this.contextMetadata.get(key);
    }

    public <T> Iterable<T> getAll(Metadata.Key<T> key) {
        return this.contextMetadata.getAll(key);
    }

    public Set<String> keys() {
        return this.contextMetadata.keys();
    }

    public <T> void put(Metadata.Key<T> key, T value) {
        this.contextMetadata.put(key, value);
    }

    public <T> boolean remove(Metadata.Key<T> key, T value) {
        return this.contextMetadata.remove(key, value);
    }

    public <T> Iterable<T> removeAll(Metadata.Key<T> key) {
        return this.contextMetadata.removeAll(key);
    }
}

