/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.builder.components;

import io.grpc.MethodDescriptor;
import org.ballerinalang.net.grpc.builder.components.ClientBuilder;
import org.ballerinalang.net.grpc.exception.BalGenerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionBuilder {
    public static final Logger LOG = LoggerFactory.getLogger(ActionBuilder.class);

    public static void build(String methodName, String reqMessageName, String resMessageName, String methodID, MethodDescriptor.MethodType methodType, ClientBuilder clientStubBal) {
        switch (methodType) {
            case UNARY: {
                clientStubBal.addBlockingFunction(methodName, reqMessageName, resMessageName, methodID);
                clientStubBal.addNonBlockingFunction(methodName, reqMessageName, methodID);
                break;
            }
            case SERVER_STREAMING: {
                clientStubBal.addNonBlockingFunction(methodName, reqMessageName, methodID);
                break;
            }
            case CLIENT_STREAMING: 
            case BIDI_STREAMING: {
                clientStubBal.addStreamingFunction(methodName, reqMessageName, methodID);
                break;
            }
            default: {
                throw new BalGenerationException("Invalid action type '" + methodType + "'.");
            }
        }
    }
}

