/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.nativeimpl.headers;

import io.grpc.Metadata;
import java.util.ArrayList;
import java.util.Base64;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BlockingNativeCallableUnit;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BStringArray;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.net.grpc.MessageHeaders;

@BallerinaFunction(orgName="ballerina", packageName="grpc", functionName="getAll", receiver=@Receiver(type=TypeKind.STRUCT, structType="Headers", structPackage="ballerina.grpc"), args={@Argument(name="headerName", type=TypeKind.STRING)}, returnType={@ReturnType(type=TypeKind.ARRAY)}, isPublic=true)
public class GetAll
extends BlockingNativeCallableUnit {
    public void execute(Context context) {
        String headerName = context.getStringArgument(0);
        BStruct headerValues = (BStruct)context.getRefArgument(0);
        MessageHeaders metadata = headerValues != null ? (MessageHeaders)headerValues.getNativeData("Metadata") : null;
        String[] headerValue = this.getHeaderValues(metadata, headerName);
        context.setReturnValues(new BValue[]{new BStringArray(headerValue)});
    }

    private String[] getHeaderValues(MessageHeaders metadata, String keyName) {
        ArrayList headerValues = new ArrayList();
        if (metadata != null) {
            if (keyName.endsWith("-bin")) {
                Metadata.Key key = Metadata.Key.of((String)keyName, (Metadata.BinaryMarshaller)Metadata.BINARY_BYTE_MARSHALLER);
                Iterable<byte[]> valueIterator = metadata.getAll(key);
                ArrayList values = new ArrayList();
                valueIterator.forEach(value -> values.add(value != null ? Base64.getEncoder().encodeToString((byte[])value) : null));
                headerValues = values;
            } else {
                Metadata.Key key = Metadata.Key.of((String)keyName, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
                Iterable<String> valueIterator = metadata.getAll(key);
                ArrayList values = new ArrayList();
                valueIterator.forEach(values::add);
                headerValues = values;
            }
        }
        return headerValues.toArray(new String[headerValues.size()]);
    }
}

