/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.nativeimpl.servicestub;

import com.google.protobuf.Descriptors;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.MetadataUtils;
import io.grpc.stub.StreamObserver;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.ballerinalang.bre.Context;
import org.ballerinalang.connector.api.BLangConnectorSPIUtil;
import org.ballerinalang.connector.api.Service;
import org.ballerinalang.connector.api.Value;
import org.ballerinalang.connector.impl.ValueImpl;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BRefValueArray;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BTypeDescValue;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.net.grpc.Message;
import org.ballerinalang.net.grpc.MessageHeaders;
import org.ballerinalang.net.grpc.MessageRegistry;
import org.ballerinalang.net.grpc.MessageUtils;
import org.ballerinalang.net.grpc.exception.GrpcClientException;
import org.ballerinalang.net.grpc.nativeimpl.servicestub.AbstractExecute;
import org.ballerinalang.net.grpc.stubs.DefaultStreamObserver;
import org.ballerinalang.net.grpc.stubs.GrpcNonBlockingStub;
import org.ballerinalang.util.codegen.ProgramFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(orgName="ballerina", packageName="grpc", functionName="streamingExecute", receiver=@Receiver(type=TypeKind.STRUCT, structType="ServiceStub", structPackage="ballerina.grpc"), args={@Argument(name="methodID", type=TypeKind.STRING), @Argument(name="listenerService", type=TypeKind.TYPEDESC), @Argument(name="headers", type=TypeKind.ARRAY)}, returnType={@ReturnType(type=TypeKind.STRUCT, structType="Client", structPackage="ballerina.grpc"), @ReturnType(type=TypeKind.STRUCT, structType="ConnectorError", structPackage="ballerina.grpc")}, isPublic=true)
public class StreamingExecute
extends AbstractExecute {
    private static final Logger LOG = LoggerFactory.getLogger(StreamingExecute.class);
    private static final int MESSAGE_HEADER_REF_INDEX = 2;

    public void execute(Context context) {
        BStruct serviceStub = (BStruct)context.getRefArgument(0);
        if (serviceStub == null) {
            this.notifyErrorReply(context, "Error while getting connector. gRPC Client connector is not initialized properly");
            return;
        }
        Object connectionStub = serviceStub.getNativeData("ServiceStub");
        if (connectionStub == null) {
            this.notifyErrorReply(context, "Error while getting connection stub. gRPC Client connector is not initialized properly");
            return;
        }
        String methodName = context.getStringArgument(0);
        if (methodName == null) {
            this.notifyErrorReply(context, "Error while processing the request. RPC endpoint doesn't set properly");
            return;
        }
        Map methodDescriptors = (Map)serviceStub.getNativeData("MethodDescriptors");
        if (methodDescriptors == null) {
            this.notifyErrorReply(context, "Error while processing the request. method descriptors doesn't set properly");
            return;
        }
        Descriptors.MethodDescriptor methodDescriptor = MessageRegistry.getInstance().getMethodDescriptor(methodName);
        if (methodDescriptor == null) {
            this.notifyErrorReply(context, "No registered method descriptor for '" + methodName + "'");
            return;
        }
        BRefValueArray headerValues = (BRefValueArray)context.getRefArgument(2);
        MessageHeaders headers = MessageUtils.getMessageHeaders(headerValues);
        if (connectionStub instanceof GrpcNonBlockingStub) {
            GrpcNonBlockingStub grpcNonBlockingStub = (GrpcNonBlockingStub)((Object)connectionStub);
            AtomicReference<Metadata> headerCapture = new AtomicReference<Metadata>();
            AtomicReference trailerCapture = new AtomicReference();
            if (headers != null) {
                grpcNonBlockingStub = (GrpcNonBlockingStub)MetadataUtils.attachHeaders((AbstractStub)grpcNonBlockingStub, (Metadata)headers.getMessageMetadata());
            }
            grpcNonBlockingStub = (GrpcNonBlockingStub)MetadataUtils.captureMetadata((AbstractStub)grpcNonBlockingStub, headerCapture, trailerCapture);
            BTypeDescValue serviceType = (BTypeDescValue)context.getRefArgument(1);
            Service callbackService = BLangConnectorSPIUtil.getServiceFromType((ProgramFile)context.getProgramFile(), (Value)this.getTypeField(serviceType));
            try {
                StreamObserver<Message> requestSender;
                MethodDescriptor.MethodType methodType = this.getMethodType(methodDescriptor);
                DefaultStreamObserver responseObserver = new DefaultStreamObserver(callbackService, headerCapture);
                if (methodType.equals((Object)MethodDescriptor.MethodType.CLIENT_STREAMING)) {
                    requestSender = grpcNonBlockingStub.executeClientStreaming(responseObserver, (MethodDescriptor<Message, Message>)((MethodDescriptor)methodDescriptors.get(methodName)));
                } else if (methodType.equals((Object)MethodDescriptor.MethodType.BIDI_STREAMING)) {
                    requestSender = grpcNonBlockingStub.executeBidiStreaming(responseObserver, (MethodDescriptor<Message, Message>)((MethodDescriptor)methodDescriptors.get(methodName)));
                } else {
                    this.notifyErrorReply(context, "Error while executing the client call. Method type " + methodType.name() + " not supported");
                    return;
                }
                BStruct connStruct = this.createStruct(context, "ClientConnection");
                connStruct.addNativeData("REQUEST_SENDER", requestSender);
                connStruct.addNativeData("REQUEST_DEFINITION", (Object)methodDescriptor.getInputType());
                BStruct clientEndpoint = (BStruct)serviceStub.getNativeData("clientEndpoint");
                clientEndpoint.addNativeData("ClientConnection", (Object)connStruct);
                context.setReturnValues(new BValue[]{clientEndpoint});
            }
            catch (RuntimeException | GrpcClientException e) {
                this.notifyErrorReply(context, "gRPC Client Connector Error :" + e.getMessage());
            }
        }
    }

    private Value getTypeField(BTypeDescValue refField) {
        if (refField == null) {
            return null;
        }
        return ValueImpl.createValue((BValue)refField);
    }
}

