/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc;

import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Locale;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.types.AttachedFunction;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.net.grpc.GrpcConstants;
import org.ballerinalang.net.grpc.MessageRegistry;
import org.ballerinalang.net.grpc.MethodDescriptor;
import org.ballerinalang.net.grpc.Status;
import org.ballerinalang.net.grpc.StreamObserver;
import org.ballerinalang.net.grpc.exception.StatusRuntimeException;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class MessageUtils {
    private static final String UNKNOWN_ERROR_DETAIL = "Unknown error occurred";
    private static final int MAX_BUFFER_LENGTH = 16384;
    private static final String GOOGLE_PROTOBUF_EMPTY = "google.protobuf.Empty";

    public static ObjectValue getHeaderObject() {
        return BallerinaValues.createObjectValue((String)"ballerina/grpc", (String)"Headers", (Object[])new Object[0]);
    }

    static boolean headersRequired(AttachedFunction function) {
        if (function == null || function.getParameterType() == null) {
            throw new RuntimeException("Invalid resource input arguments");
        }
        boolean headersRequired = false;
        for (BType paramType : function.getParameterType()) {
            if (paramType == null || !"Headers".equals(paramType.getName()) || paramType.getPackage() == null || !"grpc".equals(paramType.getPackage().getName())) continue;
            headersRequired = true;
            break;
        }
        return headersRequired;
    }

    public static long copy(InputStream from, OutputStream to) throws IOException {
        int r;
        byte[] buf = new byte[16384];
        long total = 0L;
        while ((r = from.read(buf)) != -1) {
            to.write(buf, 0, r);
            total += (long)r;
        }
        return total;
    }

    public static StreamObserver getResponseObserver(ObjectValue refType) {
        Object observerObject = refType.getNativeData("RESPONSE_OBSERVER");
        if (observerObject instanceof StreamObserver) {
            return (StreamObserver)observerObject;
        }
        return null;
    }

    public static ErrorValue getConnectorError(Throwable error) {
        String message;
        String reason;
        if (error instanceof StatusRuntimeException) {
            StatusRuntimeException statusException = (StatusRuntimeException)error;
            reason = statusException.getStatus().getReason();
            String errorDescription = statusException.getStatus().getDescription();
            message = errorDescription != null ? statusException.getStatus().getDescription() : (statusException.getStatus().getCause() != null ? statusException.getStatus().getCause().getMessage() : UNKNOWN_ERROR_DETAIL);
        } else if (error.getMessage() == null) {
            reason = "{ballerina/grpc}UnKnownError";
            message = UNKNOWN_ERROR_DETAIL;
        } else {
            reason = "{ballerina/grpc}InternalError";
            message = error.getMessage();
        }
        return BallerinaErrors.createError((String)reason, (String)message);
    }

    static int getFieldWireType(Descriptors.FieldDescriptor.Type fieldType) {
        if (fieldType == null) {
            return -1;
        }
        Integer wireType = GrpcConstants.WIRE_TYPE_MAP.get(fieldType.toProto());
        if (wireType != null) {
            return wireType;
        }
        return 2;
    }

    static void setNestedMessages(Descriptors.Descriptor resMessage, MessageRegistry messageRegistry) {
        for (Descriptors.Descriptor nestedType : resMessage.getNestedTypes()) {
            messageRegistry.addMessageDescriptor(nestedType.getName(), nestedType);
        }
        for (Descriptors.FieldDescriptor msgField : resMessage.getFields()) {
            if (!Descriptors.FieldDescriptor.Type.MESSAGE.equals((Object)msgField.getType())) continue;
            Descriptors.Descriptor msgType = msgField.getMessageType();
            messageRegistry.addMessageDescriptor(msgType.getName(), msgType);
        }
    }

    public static MethodDescriptor.MethodType getMethodType(DescriptorProtos.MethodDescriptorProto methodDescriptorProto) {
        if (methodDescriptorProto.getClientStreaming() && methodDescriptorProto.getServerStreaming()) {
            return MethodDescriptor.MethodType.BIDI_STREAMING;
        }
        if (!methodDescriptorProto.getClientStreaming() && !methodDescriptorProto.getServerStreaming()) {
            return MethodDescriptor.MethodType.UNARY;
        }
        if (methodDescriptorProto.getServerStreaming()) {
            return MethodDescriptor.MethodType.SERVER_STREAMING;
        }
        return MethodDescriptor.MethodType.CLIENT_STREAMING;
    }

    public static boolean isEmptyResponse(Descriptors.Descriptor messageDescriptor) {
        if (messageDescriptor == null) {
            return false;
        }
        return GOOGLE_PROTOBUF_EMPTY.equals(messageDescriptor.getFullName());
    }

    static void closeQuietly(InputStream message) {
        try {
            message.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static boolean isGrpcContentType(String contentType) {
        if (contentType == null) {
            return false;
        }
        if ("application/grpc".length() > contentType.length()) {
            return false;
        }
        if (!(contentType = contentType.toLowerCase(Locale.ENGLISH)).startsWith("application/grpc")) {
            return false;
        }
        if (contentType.length() == "application/grpc".length()) {
            return true;
        }
        char nextChar = contentType.charAt("application/grpc".length());
        return nextChar == '+' || nextChar == ';';
    }

    public static HttpCarbonMessage createHttpCarbonMessage(boolean isRequest) {
        HttpCarbonMessage httpCarbonMessage = isRequest ? new HttpCarbonMessage((HttpMessage)new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "")) : new HttpCarbonMessage((HttpMessage)new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK));
        return httpCarbonMessage;
    }

    static Status httpStatusToGrpcStatus(int httpStatusCode) {
        return MessageUtils.httpStatusToGrpcCode(httpStatusCode).toStatus().withDescription("HTTP status code " + httpStatusCode);
    }

    private static Status.Code httpStatusToGrpcCode(int httpStatusCode) {
        if (httpStatusCode >= 100 && httpStatusCode < 200) {
            return Status.Code.INTERNAL;
        }
        switch (httpStatusCode) {
            case 400: 
            case 431: {
                return Status.Code.INTERNAL;
            }
            case 401: {
                return Status.Code.UNAUTHENTICATED;
            }
            case 403: {
                return Status.Code.PERMISSION_DENIED;
            }
            case 404: {
                return Status.Code.UNIMPLEMENTED;
            }
            case 429: 
            case 502: 
            case 503: 
            case 504: {
                return Status.Code.UNAVAILABLE;
            }
        }
        return Status.Code.UNKNOWN;
    }

    static int statusCodeToHttpCode(Status.Code code) {
        switch (code) {
            case CANCELLED: {
                return 499;
            }
            case INVALID_ARGUMENT: 
            case FAILED_PRECONDITION: 
            case OUT_OF_RANGE: {
                return 400;
            }
            case DEADLINE_EXCEEDED: {
                return 504;
            }
            case NOT_FOUND: {
                return 404;
            }
            case ALREADY_EXISTS: 
            case ABORTED: {
                return 409;
            }
            case PERMISSION_DENIED: {
                return 403;
            }
            case UNAUTHENTICATED: {
                return 401;
            }
            case UNIMPLEMENTED: {
                return 501;
            }
            case UNAVAILABLE: {
                return 503;
            }
        }
        return 500;
    }

    private static byte[] readArray(HttpContent httpContent) {
        if (httpContent == null || httpContent.content() == null) {
            throw new RuntimeException("Http content is null");
        }
        int length = httpContent.content().readableBytes();
        byte[] bytes = new byte[length];
        httpContent.content().readBytes(bytes, 0, length);
        return bytes;
    }

    static String readAsString(HttpContent httpContent, Charset charset) {
        if (charset == null) {
            throw new RuntimeException("Charset cannot be null");
        }
        byte[] bytes = MessageUtils.readArray(httpContent);
        return new String(bytes, charset);
    }

    private MessageUtils() {
    }
}

