/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc;

import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.LastHttpContent;
import java.util.concurrent.ExecutorService;
import org.ballerinalang.jvm.util.exceptions.BallerinaConnectorException;
import org.ballerinalang.net.grpc.CompressorRegistry;
import org.ballerinalang.net.grpc.DecompressorRegistry;
import org.ballerinalang.net.grpc.InboundMessage;
import org.ballerinalang.net.grpc.MessageUtils;
import org.ballerinalang.net.grpc.OutboundMessage;
import org.ballerinalang.net.grpc.ServerCall;
import org.ballerinalang.net.grpc.ServerMethodDefinition;
import org.ballerinalang.net.grpc.ServicesRegistry;
import org.ballerinalang.net.grpc.Status;
import org.ballerinalang.net.grpc.exception.StatusRuntimeException;
import org.ballerinalang.net.http.HttpUtil;
import org.ballerinalang.runtime.threadpool.ThreadPoolFactory;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.HttpConnectorListener;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class ServerConnectorListener
implements HttpConnectorListener {
    private static final Logger log = LoggerFactory.getLogger(ServerConnectorListener.class);
    private final ServicesRegistry servicesRegistry;

    public ServerConnectorListener(ServicesRegistry servicesRegistry) {
        this.servicesRegistry = servicesRegistry;
    }

    public void onMessage(HttpCarbonMessage inboundMessage) {
        try {
            InboundMessage request = new InboundMessage(inboundMessage);
            if (!this.isValid(request)) {
                return;
            }
            OutboundMessage outboundMessage = new OutboundMessage(request);
            String path = request.getPath();
            String method = path != null ? path.subSequence(1, path.length()).toString() : null;
            this.deliver(method, request, outboundMessage);
        }
        catch (BallerinaException ex) {
            try {
                HttpUtil.handleFailure((HttpCarbonMessage)inboundMessage, (BallerinaConnectorException)new BallerinaConnectorException(ex.getMessage(), ex.getCause()));
            }
            catch (Exception e) {
                log.error("Cannot handle error using the error handler for: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void onError(Throwable throwable) {
        log.error("Error in http server connector" + throwable.getMessage(), throwable);
    }

    private void deliver(String method, InboundMessage inboundMessage, OutboundMessage outboundMessage) {
        ServerMethodDefinition methodDefinition = this.servicesRegistry.lookupMethod(method);
        if (methodDefinition == null) {
            ServerConnectorListener.handleFailure(inboundMessage.getHttpCarbonMessage(), 404, Status.Code.UNIMPLEMENTED, String.format("Method not found: %s", method));
            return;
        }
        ExecutorService wrappedExecutor = ThreadPoolFactory.getInstance().getWorkerExecutor();
        wrappedExecutor.execute(() -> {
            try {
                ServerCall.ServerStreamListener listener = this.startCall(inboundMessage, outboundMessage, method);
                ServerInboundStateListener stateListener = new ServerInboundStateListener(0x400000, listener, inboundMessage);
                stateListener.setDecompressor(inboundMessage.getMessageDecompressor());
                HttpContent httpContent = inboundMessage.getHttpCarbonMessage().getHttpContent();
                while (httpContent != null) {
                    if (httpContent instanceof LastHttpContent) {
                        stateListener.inboundDataReceived(httpContent, true);
                        break;
                    }
                    stateListener.inboundDataReceived(httpContent, false);
                    httpContent = inboundMessage.getHttpCarbonMessage().getHttpContent();
                }
            }
            catch (RuntimeException e) {
                HttpUtil.handleFailure((HttpCarbonMessage)inboundMessage.getHttpCarbonMessage(), (BallerinaConnectorException)new BallerinaConnectorException(e.getMessage(), e.getCause()));
            }
        });
    }

    private ServerCall.ServerStreamListener startCall(InboundMessage inboundMessage, OutboundMessage outboundMessage, String fullMethodName) {
        ServerMethodDefinition methodDefinition = this.servicesRegistry.lookupMethod(fullMethodName);
        ServerCall call = new ServerCall(inboundMessage, outboundMessage, methodDefinition.getMethodDescriptor(), DecompressorRegistry.getDefaultInstance(), CompressorRegistry.getDefaultInstance());
        return call.newServerStreamListener(methodDefinition.getServerCallHandler().startCall(call));
    }

    private boolean isValid(InboundMessage inboundMessage) {
        HttpHeaders headers = inboundMessage.getHeaders();
        String path = inboundMessage.getPath();
        if (path == null) {
            ServerConnectorListener.handleFailure(inboundMessage.getHttpCarbonMessage(), 404, Status.Code.UNIMPLEMENTED, "Expected path is missing");
            return false;
        }
        if (path.charAt(0) != '/') {
            ServerConnectorListener.handleFailure(inboundMessage.getHttpCarbonMessage(), 404, Status.Code.UNIMPLEMENTED, String.format("Expected path to start with /: %s", path));
            return false;
        }
        String contentType = headers.get("content-type");
        if (contentType == null) {
            ServerConnectorListener.handleFailure(inboundMessage.getHttpCarbonMessage(), 415, Status.Code.INTERNAL, "Content-Type is missing from the request");
            return false;
        }
        String contentTypeString = contentType.toString();
        if (!MessageUtils.isGrpcContentType(contentTypeString)) {
            ServerConnectorListener.handleFailure(inboundMessage.getHttpCarbonMessage(), 415, Status.Code.INTERNAL, String.format("Content-Type '%s' is not supported", contentTypeString));
            return false;
        }
        String method = inboundMessage.getHttpMethod();
        if (!"POST".equals(method)) {
            ServerConnectorListener.handleFailure(inboundMessage.getHttpCarbonMessage(), 405, Status.Code.INTERNAL, String.format("Method '%s' is not supported", method));
            return false;
        }
        return true;
    }

    private static void handleFailure(HttpCarbonMessage requestMessage, int status, Status.Code statusCode, String msg) {
        HttpCarbonMessage responseMessage = HttpUtil.createErrorMessage((String)msg, (int)status);
        responseMessage.setHeader("grpc-status", statusCode.toString());
        responseMessage.setHeader("grpc-message", msg);
        HttpUtil.sendOutboundResponse((HttpCarbonMessage)requestMessage, (HttpCarbonMessage)responseMessage);
    }

    private static class ServerInboundStateListener
    extends InboundMessage.InboundStateListener {
        final ServerCall.ServerStreamListener listener;
        final InboundMessage inboundMessage;

        ServerInboundStateListener(int maxMessageSize, ServerCall.ServerStreamListener listener, InboundMessage inboundMessage) {
            super(maxMessageSize);
            this.listener = listener;
            this.inboundMessage = inboundMessage;
        }

        @Override
        protected ServerCall.ServerStreamListener listener() {
            return this.listener;
        }

        @Override
        public void deframerClosed(boolean hasPartialMessage) {
            if (hasPartialMessage) {
                this.deframeFailed(Status.Code.INTERNAL.toStatus().withDescription("Encountered end-of-stream mid-frame").asRuntimeException());
                return;
            }
            this.listener.halfClosed();
        }

        @Override
        public void deframeFailed(Throwable cause) {
            if (cause instanceof StatusRuntimeException) {
                StatusRuntimeException exp = (StatusRuntimeException)cause;
                ServerConnectorListener.handleFailure(this.inboundMessage.getHttpCarbonMessage(), MessageUtils.statusCodeToHttpCode(exp.getStatus().getCode()), exp.getStatus().getCode(), exp.getStatus().getDescription());
            } else {
                ServerConnectorListener.handleFailure(this.inboundMessage.getHttpCarbonMessage(), 500, Status.Code.INTERNAL, cause.getMessage());
            }
        }

        void inboundDataReceived(HttpContent httpContent, boolean endOfStream) {
            this.deframe(httpContent);
            if (endOfStream) {
                this.closeDeframer(false);
            }
        }
    }
}

