/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.ballerinalang.net.grpc.MethodDescriptor;
import org.ballerinalang.net.grpc.exception.GrpcServerException;

public final class ServiceDescriptor {
    private final String name;
    private final Collection<MethodDescriptor> methods;

    private ServiceDescriptor(String name, Collection<MethodDescriptor> methods) throws GrpcServerException {
        this.name = name;
        ServiceDescriptor.validateMethodNames(name, methods);
        this.methods = Collections.unmodifiableList(new ArrayList<MethodDescriptor>(methods));
    }

    public String getName() {
        return this.name;
    }

    public Collection<MethodDescriptor> getMethods() {
        return this.methods;
    }

    private static void validateMethodNames(String serviceName, Collection<MethodDescriptor> methods) throws GrpcServerException {
        HashSet<String> allNames = new HashSet<String>(methods.size());
        for (MethodDescriptor method : methods) {
            if (method == null) {
                throw new GrpcServerException("method cannot be null");
            }
            String methodServiceName = MethodDescriptor.extractFullServiceName(method.getFullMethodName());
            if (!serviceName.equals(methodServiceName)) {
                throw new GrpcServerException(String.format("service names %s != %s", methodServiceName, serviceName));
            }
            if (allNames.add(method.getFullMethodName())) continue;
            throw new GrpcServerException(String.format("duplicate name %s", method.getFullMethodName()));
        }
    }

    public static Builder newBuilder(String name) throws GrpcServerException {
        return new Builder(name);
    }

    public static final class Builder {
        private String name;
        private List<MethodDescriptor> methods = new ArrayList<MethodDescriptor>();

        private Builder(String name) throws GrpcServerException {
            if (name == null) {
                throw new GrpcServerException("name cannot be null");
            }
            this.name = name;
        }

        public Builder addAllMethods(Collection<MethodDescriptor> methods) {
            this.methods.addAll(methods);
            return this;
        }

        public ServiceDescriptor build() throws GrpcServerException {
            return new ServiceDescriptor(this.name, this.methods);
        }
    }
}

