/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.builder;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.ValueResolver;
import com.github.jknack.handlebars.context.FieldValueResolver;
import com.github.jknack.handlebars.context.JavaBeanValueResolver;
import com.github.jknack.handlebars.context.MapValueResolver;
import com.github.jknack.handlebars.helper.StringHelpers;
import com.github.jknack.handlebars.io.ClassPathTemplateLoader;
import com.github.jknack.handlebars.io.FileTemplateLoader;
import com.github.jknack.handlebars.io.TemplateLoader;
import com.google.protobuf.DescriptorProtos;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.ballerinalang.net.grpc.MethodDescriptor;
import org.ballerinalang.net.grpc.builder.components.ClientFile;
import org.ballerinalang.net.grpc.builder.components.Descriptor;
import org.ballerinalang.net.grpc.builder.components.EnumMessage;
import org.ballerinalang.net.grpc.builder.components.Message;
import org.ballerinalang.net.grpc.builder.components.Method;
import org.ballerinalang.net.grpc.builder.components.ServiceFile;
import org.ballerinalang.net.grpc.builder.components.ServiceStub;
import org.ballerinalang.net.grpc.builder.components.StubFile;
import org.ballerinalang.net.grpc.builder.utils.BalGenConstants;
import org.ballerinalang.net.grpc.builder.utils.BalGenerationUtils;
import org.ballerinalang.net.grpc.exception.CodeBuilderException;
import org.ballerinalang.net.grpc.exception.GrpcServerException;
import org.ballerinalang.net.grpc.proto.definition.EmptyMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BallerinaFileBuilder {
    public static final Logger LOG = LoggerFactory.getLogger(BallerinaFileBuilder.class);
    private byte[] rootDescriptor;
    private Set<byte[]> dependentDescriptors;
    private String balOutPath;

    public BallerinaFileBuilder(byte[] rootDescriptor, Set<byte[]> dependentDescriptors) {
        this.setRootDescriptor(rootDescriptor);
        this.dependentDescriptors = dependentDescriptors;
    }

    public BallerinaFileBuilder(byte[] rootDescriptor, Set<byte[]> dependentDescriptors, String balOutPath) {
        this.setRootDescriptor(rootDescriptor);
        this.dependentDescriptors = dependentDescriptors;
        this.balOutPath = balOutPath;
    }

    public void build(String mode) throws CodeBuilderException {
        this.computeSourceContent(this.rootDescriptor, mode);
        for (byte[] descriptorData : this.dependentDescriptors) {
            this.computeSourceContent(descriptorData, null);
        }
    }

    private void computeSourceContent(byte[] descriptor, String mode) throws CodeBuilderException {
        try (ByteArrayInputStream targetStream = new ByteArrayInputStream(descriptor);){
            DescriptorProtos.FileDescriptorProto fileDescriptorSet = DescriptorProtos.FileDescriptorProto.parseFrom((InputStream)targetStream);
            if (fileDescriptorSet.getPackage().contains("google.protobuf")) {
                return;
            }
            List serviceDescriptotList = fileDescriptorSet.getServiceList();
            List messageTypeList = fileDescriptorSet.getMessageTypeList();
            List enumDescriptorProtos = fileDescriptorSet.getEnumTypeList();
            String filename = new File(fileDescriptorSet.getName()).getName().replace(".proto", "");
            String filePackage = fileDescriptorSet.getPackage();
            StubFile stubFileObject = new StubFile(filename);
            if (descriptor == this.rootDescriptor) {
                Iterator rootDesc = Descriptor.newBuilder(descriptor).build();
                stubFileObject.setRootDescriptor(((Descriptor)((Object)rootDesc)).getData());
                stubFileObject.addDescriptor((Descriptor)((Object)rootDesc));
                for (byte[] descriptorData : this.dependentDescriptors) {
                    Descriptor dependentDescriptor = Descriptor.newBuilder(descriptorData).build();
                    stubFileObject.addDescriptor(dependentDescriptor);
                }
            }
            if (this.balOutPath == null) {
                this.balOutPath = StringUtils.isNotBlank((CharSequence)fileDescriptorSet.getPackage()) ? fileDescriptorSet.getPackage().replace(".", BalGenConstants.FILE_SEPARATOR) : "temp";
            }
            for (DescriptorProtos.ServiceDescriptorProto serviceDescriptor : serviceDescriptotList) {
                ServiceStub.Builder serviceStubBuilder = ServiceStub.newBuilder(serviceDescriptor.getName());
                ServiceFile.Builder sampleServiceBuilder = ServiceFile.newBuilder(serviceDescriptor.getName());
                List methodList = serviceDescriptor.getMethodList();
                boolean isUnaryContains = false;
                for (DescriptorProtos.MethodDescriptorProto methodDescriptorProto : methodList) {
                    String methodID = filePackage != null && !filePackage.isEmpty() ? filePackage + "." + serviceDescriptor.getName() + "/" + methodDescriptorProto.getName() : serviceDescriptor.getName() + "/" + methodDescriptorProto.getName();
                    Method method = Method.newBuilder(methodID).setMethodDescriptor(methodDescriptorProto).build();
                    serviceStubBuilder.addMethod(method);
                    sampleServiceBuilder.addMethod(method);
                    if (MethodDescriptor.MethodType.UNARY.equals((Object)method.getMethodType())) {
                        isUnaryContains = true;
                    }
                    if (!method.containsEmptyType() || stubFileObject.messageExists("Empty")) continue;
                    Message message = Message.newBuilder(EmptyMessage.newBuilder().getDescriptor().toProto()).build();
                    stubFileObject.addMessage(message);
                }
                if (isUnaryContains) {
                    serviceStubBuilder.setType(ServiceStub.StubType.BLOCKING);
                    stubFileObject.addServiceStub(serviceStubBuilder.build());
                }
                serviceStubBuilder.setType(ServiceStub.StubType.NONBLOCKING);
                stubFileObject.addServiceStub(serviceStubBuilder.build());
                if ("client".equals(mode)) {
                    String clientFilePath = this.generateOutputFile(this.balOutPath, serviceDescriptor.getName() + "_sample_client.bal");
                    BallerinaFileBuilder.writeOutputFile(new ClientFile(serviceDescriptor.getName(), isUnaryContains), "/templates/skeleton", "sample", clientFilePath);
                }
                if (!"service".equals(mode)) continue;
                String servicePath = this.generateOutputFile(this.balOutPath, serviceDescriptor.getName() + "_sample_service.bal");
                BallerinaFileBuilder.writeOutputFile(sampleServiceBuilder.build(), "/templates/skeleton", "sampleService", servicePath);
            }
            for (DescriptorProtos.DescriptorProto descriptorProto : messageTypeList) {
                Message message = Message.newBuilder(descriptorProto).build();
                stubFileObject.addMessage(message);
            }
            for (DescriptorProtos.DescriptorProto descriptorProto : enumDescriptorProtos) {
                EnumMessage enumMessage = EnumMessage.newBuilder((DescriptorProtos.EnumDescriptorProto)descriptorProto).build();
                stubFileObject.addEnumMessage(enumMessage);
            }
            String stubFilePath = this.generateOutputFile(this.balOutPath, filename + "_pb.bal");
            BallerinaFileBuilder.writeOutputFile(stubFileObject, "/templates/skeleton", "clientStub", stubFilePath);
        }
        catch (IOException | GrpcServerException e) {
            throw new CodeBuilderException("Error while generating source files.", e);
        }
    }

    private String generateOutputFile(String outputDir, String fileName) throws IOException {
        File file;
        if (outputDir != null) {
            Files.createDirectories(Paths.get(outputDir, new String[0]), new FileAttribute[0]);
        }
        if (!(file = new File(outputDir + BalGenConstants.FILE_SEPARATOR + fileName)).isFile()) {
            Files.createFile(Paths.get(file.getAbsolutePath(), new String[0]), new FileAttribute[0]);
        }
        return file.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeOutputFile(Object object, String templateDir, String templateName, String outPath) throws IOException {
        try (PrintWriter writer = null;){
            Template template = BallerinaFileBuilder.compileTemplate(templateDir, templateName);
            Context context = Context.newBuilder((Object)object).resolver(new ValueResolver[]{MapValueResolver.INSTANCE, JavaBeanValueResolver.INSTANCE, FieldValueResolver.INSTANCE}).build();
            writer = new PrintWriter(outPath, StandardCharsets.UTF_8.name());
            writer.println(template.apply(context));
        }
    }

    private static Template compileTemplate(String defaultTemplateDir, String templateName) throws IOException {
        String templatesDirPath = System.getProperty("templates.dir.path", defaultTemplateDir);
        ClassPathTemplateLoader cpTemplateLoader = new ClassPathTemplateLoader(templatesDirPath);
        FileTemplateLoader fileTemplateLoader = new FileTemplateLoader(templatesDirPath);
        cpTemplateLoader.setSuffix(".mustache");
        fileTemplateLoader.setSuffix(".mustache");
        Handlebars handlebars = new Handlebars().with(new TemplateLoader[]{cpTemplateLoader, fileTemplateLoader});
        handlebars.registerHelpers(StringHelpers.class);
        handlebars.registerHelper("equals", (object, options) -> {
            Object param0 = options.param(0);
            if (param0 == null) {
                throw new IllegalArgumentException("found n'null', expected 'string'");
            }
            CharSequence result = object != null && object.toString().equals(param0.toString()) ? options.fn(options.context) : null;
            return result;
        });
        handlebars.registerHelper("camelcase", (object, options) -> {
            if (object instanceof String) {
                return BalGenerationUtils.toCamelCase((String)object);
            }
            return "";
        });
        handlebars.registerHelper("uppercase", (object, options) -> {
            if (object instanceof String) {
                return ((String)object).toUpperCase(Locale.ENGLISH);
            }
            return "";
        });
        handlebars.registerHelper("not_equal", (object, options) -> {
            Object param0 = options.param(0);
            if (param0 == null) {
                throw new IllegalArgumentException("found n'null', expected 'string'");
            }
            CharSequence result = object == null || !object.toString().equals(param0.toString()) ? options.fn(options.context) : null;
            return result;
        });
        return handlebars.compile(templateName);
    }

    private void setRootDescriptor(byte[] rootDescriptor) {
        this.rootDescriptor = new byte[rootDescriptor.length];
        this.rootDescriptor = Arrays.copyOf(rootDescriptor, rootDescriptor.length);
    }
}

