/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.builder.components;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.ballerinalang.net.grpc.builder.components.Descriptor;
import org.ballerinalang.net.grpc.builder.components.EnumMessage;
import org.ballerinalang.net.grpc.builder.components.Message;
import org.ballerinalang.net.grpc.builder.components.ServiceStub;

public class StubFile {
    private String rootDescriptor;
    private Set<Descriptor> descriptors = new TreeSet<Descriptor>((descriptor1, descriptor2) -> {
        if (descriptor1.getKey().equalsIgnoreCase(descriptor2.getKey())) {
            return 0;
        }
        return 1;
    });
    private List<Message> messageList = new ArrayList<Message>();
    private List<EnumMessage> enumList = new ArrayList<EnumMessage>();
    private List<ServiceStub> stubList = new ArrayList<ServiceStub>();
    private String fileName;

    public StubFile(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getRootDescriptor() {
        return this.rootDescriptor;
    }

    public void setRootDescriptor(String rootDescriptor) {
        this.rootDescriptor = rootDescriptor;
    }

    public void addDescriptor(Descriptor descriptor) {
        this.descriptors.add(descriptor);
    }

    public Set<Descriptor> getDescriptors() {
        return this.descriptors;
    }

    public void addMessage(Message message) {
        this.messageList.add(message);
    }

    public boolean messageExists(String messageName) {
        if (messageName == null) {
            return false;
        }
        for (Message message : this.messageList) {
            if (!messageName.equals(message.getMessageName())) continue;
            return true;
        }
        return false;
    }

    public List<Message> getMessageList() {
        return this.messageList;
    }

    public void addEnumMessage(EnumMessage message) {
        this.enumList.add(message);
    }

    public List<EnumMessage> getEnumList() {
        return this.enumList;
    }

    public void addServiceStub(ServiceStub serviceStub) {
        this.stubList.add(serviceStub);
    }

    public List<ServiceStub> getStubList() {
        return this.stubList;
    }
}

