/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.nativeimpl.client;

import com.google.protobuf.Descriptors;
import io.netty.handler.codec.http.HttpHeaders;
import java.util.Map;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.connector.NonBlockingCallback;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.net.grpc.Message;
import org.ballerinalang.net.grpc.MethodDescriptor;
import org.ballerinalang.net.grpc.Status;
import org.ballerinalang.net.grpc.nativeimpl.client.AbstractExecute;
import org.ballerinalang.net.grpc.stubs.BlockingStub;
import org.ballerinalang.net.http.DataContext;

@BallerinaFunction(orgName="ballerina", packageName="grpc", functionName="blockingExecute", receiver=@Receiver(type=TypeKind.OBJECT, structType="Client", structPackage="ballerina/grpc"), isPublic=true)
public class BlockingExecute
extends AbstractExecute {
    public static Object blockingExecute(Strand strand, ObjectValue clientEndpoint, String methodName, Object payloadBValue, Object headerValues) {
        Descriptors.MethodDescriptor methodDescriptor;
        if (clientEndpoint == null) {
            return BlockingExecute.notifyErrorReply(Status.Code.INTERNAL, "Error while getting connector. gRPC client connector is not initialized properly");
        }
        Object connectionStub = clientEndpoint.getNativeData("Stub");
        if (connectionStub == null) {
            return BlockingExecute.notifyErrorReply(Status.Code.INTERNAL, "Error while getting connection stub. gRPC Client connector is not initialized properly");
        }
        if (methodName == null) {
            return BlockingExecute.notifyErrorReply(Status.Code.INTERNAL, "Error while processing the request. RPC endpoint doesn't set properly");
        }
        Map methodDescriptors = (Map)clientEndpoint.getNativeData("MethodDescriptors");
        if (methodDescriptors == null) {
            return BlockingExecute.notifyErrorReply(Status.Code.INTERNAL, "Error while processing the request. method descriptors doesn't set properly");
        }
        Descriptors.MethodDescriptor methodDescriptor2 = methodDescriptor = methodDescriptors.get(methodName) != null ? ((MethodDescriptor)methodDescriptors.get(methodName)).getSchemaDescriptor() : null;
        if (methodDescriptor == null) {
            return BlockingExecute.notifyErrorReply(Status.Code.INTERNAL, "No registered method descriptor for '" + methodName + "'");
        }
        if (connectionStub instanceof BlockingStub) {
            Message requestMsg = new Message(methodDescriptor.getInputType().getName(), payloadBValue);
            HttpHeaders headers = null;
            if (headerValues != null && TypeChecker.getType((Object)headerValues).getTag() == 35) {
                headers = (HttpHeaders)((ObjectValue)headerValues).getNativeData("MessageHeaders");
            }
            if (headers != null) {
                requestMsg.setHeaders(headers);
            }
            BlockingStub blockingStub = (BlockingStub)connectionStub;
            try {
                MethodDescriptor.MethodType methodType = BlockingExecute.getMethodType(methodDescriptor);
                if (!methodType.equals((Object)MethodDescriptor.MethodType.UNARY)) {
                    return BlockingExecute.notifyErrorReply(Status.Code.INTERNAL, "Error while executing the client call. Method type " + methodType.name() + " not supported");
                }
                DataContext dataContext = new DataContext(strand, new NonBlockingCallback(strand), null);
                blockingStub.executeUnary(requestMsg, (MethodDescriptor)methodDescriptors.get(methodName), dataContext);
            }
            catch (Exception e) {
                return BlockingExecute.notifyErrorReply(Status.Code.INTERNAL, "gRPC Client Connector Error :" + e.getMessage());
            }
        } else {
            return BlockingExecute.notifyErrorReply(Status.Code.INTERNAL, "Error while processing the request message. Connection Sub type not supported");
        }
        return null;
    }
}

