/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.nativeimpl.clientendpoint;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.net.grpc.MessageUtils;
import org.ballerinalang.net.grpc.Status;
import org.ballerinalang.net.grpc.exception.StatusRuntimeException;
import org.ballerinalang.net.http.HttpConnectionManager;
import org.ballerinalang.net.http.HttpUtil;
import org.wso2.transport.http.netty.contract.HttpClientConnector;
import org.wso2.transport.http.netty.contract.config.SenderConfiguration;
import org.wso2.transport.http.netty.contract.config.TransportsConfiguration;
import org.wso2.transport.http.netty.contractimpl.sender.channel.pool.ConnectionManager;
import org.wso2.transport.http.netty.message.HttpConnectorUtil;

@BallerinaFunction(orgName="ballerina", packageName="grpc", functionName="init", receiver=@Receiver(type=TypeKind.OBJECT, structType="Client", structPackage="ballerina/grpc"), isPublic=true)
public class Init {
    public static Object init(Strand strand, ObjectValue clientEndpoint, String urlString, MapValue clientEndpointConfig, MapValue globalPoolConfig) {
        URL url;
        HttpConnectionManager connectionManager = HttpConnectionManager.getInstance();
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            return MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("Malformed URL: " + urlString)));
        }
        String scheme = url.getProtocol();
        Map properties = HttpConnectorUtil.getTransportProperties((TransportsConfiguration)connectionManager.getTransportConfig());
        SenderConfiguration senderConfiguration = HttpConnectorUtil.getSenderConfiguration((TransportsConfiguration)connectionManager.getTransportConfig(), (String)scheme);
        if (connectionManager.isHTTPTraceLoggerEnabled()) {
            senderConfiguration.setHttpTraceLogEnabled(true);
        }
        senderConfiguration.setTLSStoreType("PKCS12");
        try {
            HttpUtil.populateSenderConfigurations((SenderConfiguration)senderConfiguration, (MapValue)clientEndpointConfig);
            MapValue userDefinedPoolConfig = (MapValue)clientEndpointConfig.get((Object)"poolConfig");
            ConnectionManager poolManager = userDefinedPoolConfig == null ? HttpUtil.getConnectionManager((MapValue)globalPoolConfig) : HttpUtil.getConnectionManager((MapValue)userDefinedPoolConfig);
            senderConfiguration.setHttpVersion("2.0");
            senderConfiguration.setForceHttp2(true);
            HttpClientConnector clientConnector = HttpUtil.createHttpWsConnectionFactory().createHttpClientConnector(properties, senderConfiguration, poolManager);
            clientEndpoint.addNativeData("ClientConnector", (Object)clientConnector);
            clientEndpoint.addNativeData("url", (Object)urlString);
        }
        catch (RuntimeException ex) {
            return MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withCause(ex)));
        }
        return null;
    }
}

