/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.nativeimpl.serviceendpoint;

import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.net.grpc.MessageUtils;
import org.ballerinalang.net.grpc.ServerConnectorListener;
import org.ballerinalang.net.grpc.ServerConnectorPortBindingListener;
import org.ballerinalang.net.grpc.ServicesRegistry;
import org.ballerinalang.net.grpc.Status;
import org.ballerinalang.net.grpc.exception.StatusRuntimeException;
import org.ballerinalang.net.grpc.nativeimpl.AbstractGrpcNativeFunction;
import org.wso2.transport.http.netty.contract.HttpConnectorListener;
import org.wso2.transport.http.netty.contract.PortBindingEventListener;
import org.wso2.transport.http.netty.contract.ServerConnector;
import org.wso2.transport.http.netty.contract.ServerConnectorFuture;

@BallerinaFunction(orgName="ballerina", packageName="grpc", functionName="start", receiver=@Receiver(type=TypeKind.OBJECT, structType="Listener", structPackage="ballerina/grpc"), isPublic=true)
public class Start
extends AbstractGrpcNativeFunction {
    private static Object startServerConnector(ObjectValue listener, ServicesRegistry servicesRegistry) {
        ServerConnector serverConnector = Start.getServerConnector(listener);
        ServerConnectorFuture serverConnectorFuture = serverConnector.start();
        serverConnectorFuture.setHttpConnectorListener((HttpConnectorListener)new ServerConnectorListener(servicesRegistry));
        serverConnectorFuture.setPortBindingEventListener((PortBindingEventListener)new ServerConnectorPortBindingListener());
        try {
            serverConnectorFuture.sync();
        }
        catch (Exception ex) {
            return MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("Failed to start server connector '" + serverConnector.getConnectorID() + "'. " + ex.getMessage())));
        }
        listener.addNativeData("CONNECTOR_STARTED", (Object)true);
        return null;
    }

    public static Object start(Strand strand, ObjectValue listener) {
        ServicesRegistry.Builder servicesRegistryBuilder = Start.getServiceRegistryBuilder(listener);
        if (!Start.isConnectorStarted(listener)) {
            return Start.startServerConnector(listener, servicesRegistryBuilder.build());
        }
        return null;
    }
}

