/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.net.grpc.Codec;
import org.ballerinalang.net.grpc.Compressor;
import org.ballerinalang.net.grpc.Drainable;
import org.ballerinalang.net.grpc.KnownLength;
import org.ballerinalang.net.grpc.MessageUtils;
import org.ballerinalang.net.grpc.Status;
import org.ballerinalang.net.grpc.exception.StatusRuntimeException;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class MessageFramer {
    private static final int NO_MAX_OUTBOUND_MESSAGE_SIZE = -1;
    private static final int HEADER_LENGTH = 5;
    private static final byte UNCOMPRESSED = 0;
    private static final byte COMPRESSED = 1;
    private int maxOutboundMessageSize = -1;
    private ByteBuffer buffer;
    private Compressor compressor = Codec.Identity.NONE;
    private boolean messageCompression = true;
    private final OutputStreamAdapter outputStreamAdapter = new OutputStreamAdapter();
    private final byte[] headerScratch = new byte[5];
    private final HttpCarbonMessage carbonMessage;
    private boolean closed;
    private static final int MIN_BUFFER = 4096;
    private static final int MAX_BUFFER = 0x100000;

    MessageFramer(HttpCarbonMessage carbonMessage) {
        this.carbonMessage = carbonMessage;
    }

    public void setCompressor(Compressor compressor) {
        this.compressor = compressor;
    }

    public void setMessageCompression(boolean enable) {
        this.messageCompression = enable;
    }

    public void writePayload(InputStream message) {
        int written;
        int messageLength;
        this.verifyNotClosed();
        boolean compressed = this.messageCompression && this.compressor != Codec.Identity.NONE;
        try {
            messageLength = this.getKnownLength(message);
            written = messageLength != 0 && compressed ? this.writeCompressed(message) : this.writeUncompressed(message, messageLength);
        }
        catch (StatusRuntimeException e) {
            throw e;
        }
        catch (IOException | RuntimeException e) {
            throw Status.Code.INTERNAL.toStatus().withDescription("Failed to frame message").withCause(e).asRuntimeException();
        }
        if (messageLength != -1 && written != messageLength) {
            String err = String.format("Message length inaccurate %s != %s", written, messageLength);
            throw Status.Code.INTERNAL.toStatus().withDescription(err).asRuntimeException();
        }
    }

    private int writeUncompressed(InputStream message, int messageLength) throws IOException {
        if (messageLength != -1) {
            return this.writeKnownLengthUncompressed(message, messageLength);
        }
        BufferChainOutputStream bufferChain = new BufferChainOutputStream();
        int written = MessageFramer.writeToOutputStream(message, bufferChain);
        if (this.maxOutboundMessageSize >= 0 && written > this.maxOutboundMessageSize) {
            throw Status.Code.RESOURCE_EXHAUSTED.toStatus().withDescription(String.format("message too large %d > %d", written, this.maxOutboundMessageSize)).asRuntimeException();
        }
        this.writeBufferChain(bufferChain, false);
        return written;
    }

    private int writeCompressed(InputStream message) throws IOException {
        int written;
        BufferChainOutputStream bufferChain = new BufferChainOutputStream();
        try (OutputStream compressingStream = this.compressor.compress(bufferChain);){
            written = MessageFramer.writeToOutputStream(message, compressingStream);
        }
        if (this.maxOutboundMessageSize >= 0 && written > this.maxOutboundMessageSize) {
            throw Status.Code.RESOURCE_EXHAUSTED.toStatus().withDescription(String.format("message too large %d > %d", written, this.maxOutboundMessageSize)).asRuntimeException();
        }
        this.writeBufferChain(bufferChain, true);
        return written;
    }

    private int getKnownLength(InputStream inputStream) throws IOException {
        if (inputStream instanceof KnownLength || inputStream instanceof ByteArrayInputStream) {
            return inputStream.available();
        }
        return -1;
    }

    private int writeKnownLengthUncompressed(InputStream message, int messageLength) throws IOException {
        if (this.maxOutboundMessageSize >= 0 && messageLength > this.maxOutboundMessageSize) {
            throw Status.Code.RESOURCE_EXHAUSTED.toStatus().withDescription(String.format("message too large %d > %d", messageLength, this.maxOutboundMessageSize)).asRuntimeException();
        }
        ByteBuffer header = ByteBuffer.wrap(this.headerScratch);
        header.put((byte)0);
        header.putInt(messageLength);
        if (this.buffer == null) {
            this.buffer = ByteBuffer.allocate(header.position() + messageLength);
        }
        this.writeRaw(this.headerScratch, 0, header.position());
        return MessageFramer.writeToOutputStream(message, this.outputStreamAdapter);
    }

    private void writeBufferChain(BufferChainOutputStream bufferChain, boolean compressed) {
        ByteBuffer header = ByteBuffer.wrap(this.headerScratch);
        header.put(compressed ? (byte)1 : 0);
        int messageLength = bufferChain.readableBytes();
        header.putInt(messageLength);
        if (this.buffer == null) {
            this.buffer = ByteBuffer.allocate(header.position() + messageLength);
        }
        this.writeRaw(this.headerScratch, 0, header.position());
        if (messageLength == 0) {
            return;
        }
        List bufferList = bufferChain.bufferList;
        for (ByteBuffer byteBuffer : bufferList) {
            this.buffer.put(byteBuffer.array(), 0, byteBuffer.limit() - 1);
        }
    }

    private static int writeToOutputStream(InputStream message, OutputStream outputStream) throws IOException {
        if (message instanceof Drainable) {
            return ((Drainable)((Object)message)).drainTo(outputStream);
        }
        return (int)MessageUtils.copy(message, outputStream);
    }

    private void writeRaw(byte[] b, int off, int len) {
        while (len > 0) {
            if (this.buffer != null && this.buffer.limit() == 0) {
                this.commitToSink(false);
            }
            if (this.buffer == null) {
                this.buffer = ByteBuffer.allocate(len);
            }
            int toWrite = Math.min(len, this.buffer.limit());
            this.buffer.put(b, off, toWrite);
            off += toWrite;
            len -= toWrite;
        }
    }

    public void flush() {
        if (this.buffer != null && this.buffer.limit() > 0) {
            this.commitToSink(false);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() {
        if (!this.isClosed()) {
            this.closed = true;
            if (this.buffer != null && this.buffer.limit() == 0) {
                this.releaseBuffer();
            }
            this.commitToSink(true);
        }
    }

    public void dispose() {
        this.closed = true;
        this.releaseBuffer();
    }

    private void releaseBuffer() {
        if (this.buffer != null) {
            this.buffer.clear();
            this.buffer = null;
        }
    }

    private void commitToSink(boolean endOfStream) {
        ByteBuf content = Unpooled.buffer((int)0);
        if (this.buffer != null) {
            content = Unpooled.wrappedBuffer((ByteBuffer)((ByteBuffer)this.buffer.rewind()));
        }
        if (endOfStream) {
            this.carbonMessage.addHttpContent((HttpContent)new DefaultLastHttpContent(content));
        } else {
            this.carbonMessage.addHttpContent((HttpContent)new DefaultHttpContent(content));
        }
        this.buffer = null;
    }

    private void verifyNotClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException("Framer already closed");
        }
    }

    private static final class BufferChainOutputStream
    extends OutputStream {
        private final List<ByteBuffer> bufferList = new ArrayList<ByteBuffer>();
        private ByteBuffer current;

        private BufferChainOutputStream() {
        }

        @Override
        public void write(int b) {
            if (this.current != null && this.current.limit() > 0) {
                this.current.put((byte)b);
                return;
            }
            byte[] singleByte = new byte[]{(byte)b};
            this.write(singleByte, 0, 1);
        }

        @Override
        public void write(byte[] b, int off, int len) {
            if (this.current == null) {
                int capacityHint = Math.min(0x100000, Math.max(4096, len));
                this.current = ByteBuffer.allocate(capacityHint);
                this.bufferList.add(this.current);
            }
            while (len > 0) {
                int canWrite = Math.min(len, this.current.limit());
                if (canWrite == 0) {
                    int needed = Math.max(len, this.current.limit() * 2);
                    this.current = ByteBuffer.allocate(needed);
                    this.bufferList.add(this.current);
                    continue;
                }
                this.current.put(b, off, canWrite);
                off += canWrite;
                len -= canWrite;
            }
        }

        private int readableBytes() {
            int readable = 0;
            for (ByteBuffer writableBuffer : this.bufferList) {
                readable += writableBuffer.limit();
            }
            return readable;
        }
    }

    private class OutputStreamAdapter
    extends OutputStream {
        private OutputStreamAdapter() {
        }

        @Override
        public void write(int b) {
            byte[] singleByte = new byte[]{(byte)b};
            this.write(singleByte, 0, 1);
        }

        @Override
        public void write(byte[] b, int off, int len) {
            MessageFramer.this.writeRaw(b, off, len);
        }
    }
}

