/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc;

import java.util.Optional;
import org.ballerinalang.jvm.observability.ObserveUtils;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.net.grpc.ClientCall;
import org.ballerinalang.net.grpc.ClientConnectorListener;
import org.ballerinalang.net.grpc.DataContext;
import org.wso2.transport.http.netty.contract.exceptions.ClientConnectorException;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class ObservableClientConnectorListener
extends ClientConnectorListener {
    private final DataContext context;

    public ObservableClientConnectorListener(ClientCall.ClientStreamListener streamListener, DataContext context) {
        super(streamListener);
        this.context = context;
    }

    @Override
    public void onMessage(HttpCarbonMessage httpCarbonMessage) {
        super.onMessage(httpCarbonMessage);
        Integer statusCode = (Integer)httpCarbonMessage.getProperty("statusCode");
        this.addHttpStatusCode(statusCode == null ? 0 : statusCode);
    }

    @Override
    public void onError(Throwable throwable) {
        super.onError(throwable);
        if (throwable instanceof ClientConnectorException) {
            ClientConnectorException clientConnectorException = (ClientConnectorException)throwable;
            this.addHttpStatusCode(clientConnectorException.getHttpStatusCode());
            Optional observerContext = ObserveUtils.getObserverContextOfCurrentFrame((Strand)this.context.getStrand());
            observerContext.ifPresent(ctx -> {
                ctx.addProperty("error", (Object)Boolean.TRUE);
                ctx.addProperty("error_message", (Object)throwable.getMessage());
            });
        }
    }

    private void addHttpStatusCode(int statusCode) {
        Optional observerContext = ObserveUtils.getObserverContextOfCurrentFrame((Strand)this.context.getStrand());
        observerContext.ifPresent(ctx -> ctx.addTag("http.status_code", String.valueOf(statusCode)));
    }
}

