/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc;

import com.google.protobuf.ByteString;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.util.HashMap;
import org.ballerinalang.jvm.BRuntime;
import org.ballerinalang.jvm.types.AttachedFunction;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.types.BRecordType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.types.TypeFlags;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.net.grpc.MessageParser;
import org.ballerinalang.net.grpc.MessageRegistry;
import org.ballerinalang.net.grpc.MessageUtils;
import org.ballerinalang.net.grpc.MethodDescriptor;
import org.ballerinalang.net.grpc.ProtoUtils;
import org.ballerinalang.net.grpc.ServerServiceDefinition;
import org.ballerinalang.net.grpc.ServiceResource;
import org.ballerinalang.net.grpc.exception.GrpcServerException;
import org.ballerinalang.net.grpc.listener.ServerCallHandler;
import org.ballerinalang.net.grpc.listener.StreamingServerCallHandler;
import org.ballerinalang.net.grpc.listener.UnaryServerCallHandler;
import org.ballerinalang.net.grpc.proto.definition.StandardDescriptorBuilder;

public class ServicesBuilderUtils {
    public static ServerServiceDefinition getServiceDefinition(BRuntime runtime, ObjectValue service, Object annotationData) throws GrpcServerException {
        Descriptors.FileDescriptor fileDescriptor = ServicesBuilderUtils.getDescriptor(annotationData);
        if (fileDescriptor == null) {
            throw new GrpcServerException("Couldn't find the service descriptor.");
        }
        String serviceName = ServicesBuilderUtils.getServiceName(service);
        Descriptors.ServiceDescriptor serviceDescriptor = fileDescriptor.findServiceByName(serviceName);
        if (serviceDescriptor == null) {
            throw new GrpcServerException("Couldn't find the service descriptor for the service: " + serviceName);
        }
        return ServicesBuilderUtils.getServiceDefinition(runtime, service, serviceDescriptor);
    }

    private static String getServiceName(ObjectValue service) {
        MapValue configMap;
        String providedName;
        Object serviceConfigData = service.getType().getAnnotation("ballerina/grpc:ServiceConfig");
        if (serviceConfigData != null && (providedName = (configMap = (MapValue)serviceConfigData).getStringValue("name")) != null && !providedName.isEmpty()) {
            return providedName;
        }
        String serviceTypeName = service.getType().getName();
        String[] splitValues = serviceTypeName.split("\\$\\$");
        return splitValues[0];
    }

    private static ServerServiceDefinition getServiceDefinition(BRuntime runtime, ObjectValue service, Descriptors.ServiceDescriptor serviceDescriptor) throws GrpcServerException {
        String serviceName = serviceDescriptor.getFullName();
        ServerServiceDefinition.Builder serviceDefBuilder = ServerServiceDefinition.builder(serviceName);
        for (Descriptors.MethodDescriptor methodDescriptor : serviceDescriptor.getMethods()) {
            ServerCallHandler serverCallHandler;
            MethodDescriptor.MethodType methodType;
            String methodName = serviceName + "/" + methodDescriptor.getName();
            Descriptors.Descriptor requestDescriptor = serviceDescriptor.findMethodByName(methodDescriptor.getName()).getInputType();
            Descriptors.Descriptor responseDescriptor = serviceDescriptor.findMethodByName(methodDescriptor.getName()).getOutputType();
            MessageRegistry messageRegistry = MessageRegistry.getInstance();
            messageRegistry.addMessageDescriptor(requestDescriptor.getName(), requestDescriptor);
            MessageUtils.setNestedMessages(requestDescriptor, messageRegistry);
            messageRegistry.addMessageDescriptor(responseDescriptor.getName(), responseDescriptor);
            MessageUtils.setNestedMessages(responseDescriptor, messageRegistry);
            MethodDescriptor.Marshaller reqMarshaller = null;
            HashMap<String, ServiceResource> resourceMap = new HashMap<String, ServiceResource>();
            ServiceResource mappedResource = null;
            for (AttachedFunction function : service.getType().getAttachedFunctions()) {
                if (methodDescriptor.getName().equals(function.getName())) {
                    mappedResource = new ServiceResource(runtime, service, function);
                    reqMarshaller = ProtoUtils.marshaller(new MessageParser(requestDescriptor.getName(), ServicesBuilderUtils.getResourceInputParameterType(function)));
                } else if ("onMessage".equals(function.getName())) {
                    reqMarshaller = ProtoUtils.marshaller(new MessageParser(requestDescriptor.getName(), ServicesBuilderUtils.getResourceInputParameterType(function)));
                }
                resourceMap.put(function.getName(), new ServiceResource(runtime, service, function));
            }
            if (methodDescriptor.toProto().getServerStreaming() && methodDescriptor.toProto().getClientStreaming()) {
                methodType = MethodDescriptor.MethodType.BIDI_STREAMING;
                serverCallHandler = new StreamingServerCallHandler(methodDescriptor, resourceMap);
            } else if (methodDescriptor.toProto().getClientStreaming()) {
                methodType = MethodDescriptor.MethodType.CLIENT_STREAMING;
                serverCallHandler = new StreamingServerCallHandler(methodDescriptor, resourceMap);
            } else if (methodDescriptor.toProto().getServerStreaming()) {
                methodType = MethodDescriptor.MethodType.SERVER_STREAMING;
                serverCallHandler = new UnaryServerCallHandler(methodDescriptor, mappedResource);
            } else {
                methodType = MethodDescriptor.MethodType.UNARY;
                serverCallHandler = new UnaryServerCallHandler(methodDescriptor, mappedResource);
            }
            if (reqMarshaller == null) {
                reqMarshaller = ProtoUtils.marshaller(new MessageParser(requestDescriptor.getName(), ServicesBuilderUtils.getBallerinaValueType(service.getType().getPackage(), requestDescriptor.getName())));
            }
            MethodDescriptor.Marshaller resMarshaller = ProtoUtils.marshaller(new MessageParser(responseDescriptor.getName(), ServicesBuilderUtils.getBallerinaValueType(service.getType().getPackage(), responseDescriptor.getName())));
            MethodDescriptor.Builder methodBuilder = MethodDescriptor.newBuilder();
            MethodDescriptor grpcMethodDescriptor = methodBuilder.setType(methodType).setFullMethodName(methodName).setRequestMarshaller(reqMarshaller).setResponseMarshaller(resMarshaller).setSchemaDescriptor(methodDescriptor).build();
            serviceDefBuilder.addMethod(grpcMethodDescriptor, serverCallHandler);
        }
        return serviceDefBuilder.build();
    }

    private ServicesBuilderUtils() {
    }

    private static Descriptors.FileDescriptor getDescriptor(Object annotationData) throws GrpcServerException {
        if (annotationData == null) {
            return null;
        }
        try {
            MapValue annotationMap = (MapValue)annotationData;
            String descriptorData = annotationMap.getStringValue("descriptor");
            MapValue descMap = annotationMap.getMapValue("descMap");
            return ServicesBuilderUtils.getFileDescriptor(descriptorData, (MapValue<String, String>)descMap);
        }
        catch (Descriptors.DescriptorValidationException | IOException e) {
            throw new GrpcServerException("Error while reading the service proto descriptor. check the service implementation. ", e);
        }
    }

    private static Descriptors.FileDescriptor getFileDescriptor(String descriptorData, MapValue<String, String> descMap) throws InvalidProtocolBufferException, Descriptors.DescriptorValidationException, GrpcServerException {
        byte[] descriptor = ServicesBuilderUtils.hexStringToByteArray(descriptorData);
        if (descriptor.length == 0) {
            throw new GrpcServerException("Error while reading the service proto descriptor. input descriptor string is null.");
        }
        DescriptorProtos.FileDescriptorProto descriptorProto = DescriptorProtos.FileDescriptorProto.parseFrom((byte[])descriptor);
        if (descriptorProto == null) {
            throw new GrpcServerException("Error while reading the service proto descriptor. File proto descriptor is null.");
        }
        Descriptors.FileDescriptor[] fileDescriptors = new Descriptors.FileDescriptor[descriptorProto.getDependencyList().size()];
        int i = 0;
        for (ByteString dependency : descriptorProto.getDependencyList().asByteStringList()) {
            Descriptors.FileDescriptor dependentDescriptor;
            String dependencyKey = dependency.toStringUtf8();
            if (descMap.containsKey((Object)dependencyKey)) {
                fileDescriptors[i++] = ServicesBuilderUtils.getFileDescriptor((String)descMap.get((Object)dependencyKey), descMap);
                continue;
            }
            if (descMap.size() != 0 || (dependentDescriptor = StandardDescriptorBuilder.getFileDescriptor(dependencyKey)) == null) continue;
            fileDescriptors[i++] = dependentDescriptor;
        }
        if (fileDescriptors.length > 0 && i == 0) {
            throw new GrpcServerException("Error while reading the service proto descriptor. Couldn't find any dependent descriptors.");
        }
        return Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)descriptorProto, (Descriptors.FileDescriptor[])fileDescriptors);
    }

    public static byte[] hexStringToByteArray(String sDescriptor) {
        if (sDescriptor == null) {
            return new byte[0];
        }
        int len = sDescriptor.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(sDescriptor.charAt(i), 16) << 4) + Character.digit(sDescriptor.charAt(i + 1), 16));
        }
        return data;
    }

    static BType getBallerinaValueType(BPackage bPackage, String protoType) {
        if (protoType.equalsIgnoreCase("DoubleValue") || protoType.equalsIgnoreCase("FloatValue")) {
            return BTypes.typeFloat;
        }
        if (protoType.equalsIgnoreCase("Int32Value") || protoType.equalsIgnoreCase("Int64Value") || protoType.equalsIgnoreCase("UInt32Value") || protoType.equalsIgnoreCase("UInt64Value")) {
            return BTypes.typeInt;
        }
        if (protoType.equalsIgnoreCase("BoolValue")) {
            return BTypes.typeBoolean;
        }
        if (protoType.equalsIgnoreCase("StringValue")) {
            return BTypes.typeString;
        }
        if (protoType.equalsIgnoreCase("Empty")) {
            return BTypes.typeNull;
        }
        if (protoType.equalsIgnoreCase("BytesValue")) {
            return new BArrayType(BTypes.typeByte);
        }
        return new BRecordType(protoType, bPackage, 0, true, TypeFlags.asMask((int[])new int[]{2, 4}));
    }

    private static BType getResourceInputParameterType(AttachedFunction attachedFunction) {
        BType[] inputParams = attachedFunction.type.getParameterType();
        if (inputParams.length > 1) {
            BType inputType = inputParams[1];
            if (inputType != null && "Headers".equals(inputType.getName()) && inputType.getPackage() != null && "grpc".equals(inputType.getPackage().getName())) {
                return BTypes.typeNull;
            }
            return inputParams[1];
        }
        return BTypes.typeNull;
    }
}

