/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.builder.components;

import com.google.protobuf.DescriptorProtos;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.ballerinalang.net.grpc.builder.components.EnumMessage;
import org.ballerinalang.net.grpc.builder.components.Field;

public class Message {
    private List<Field> fieldList;
    private String messageName;
    private Map<String, List<Field>> oneofFieldMap;
    private List<EnumMessage> enumList;
    private List<Message> nestedMessageList;
    private List<Message> mapList;

    private Message(String messageName, List<Field> fieldList) {
        this.messageName = messageName;
        this.fieldList = fieldList;
    }

    private void setOneofFieldMap(Map<String, List<Field>> oneofFieldMap) {
        this.oneofFieldMap = oneofFieldMap;
    }

    public Map<String, List<Field>> getOneofFieldMap() {
        return this.oneofFieldMap;
    }

    public List<EnumMessage> getEnumList() {
        return this.enumList;
    }

    private void setEnumList(List<EnumMessage> enumList) {
        this.enumList = enumList;
    }

    public void setMapList(List<Message> mapList) {
        this.mapList = mapList;
    }

    public List<Message> getMapList() {
        return this.mapList;
    }

    public static Builder newBuilder(DescriptorProtos.DescriptorProto messageDescriptor) {
        return new Builder(messageDescriptor);
    }

    public List<Message> getNestedMessageList() {
        return this.nestedMessageList;
    }

    private void setNestedMessageList(List<Message> nestedMessageList) {
        this.nestedMessageList = nestedMessageList;
    }

    public List<Field> getFieldList() {
        return this.fieldList;
    }

    public String getMessageName() {
        return this.messageName;
    }

    public void setMessageName(String messageName) {
        this.messageName = messageName;
    }

    public static class Builder {
        private DescriptorProtos.DescriptorProto messageDescriptor;

        public Message build() {
            ArrayList<Message> nestedMessageList = new ArrayList<Message>();
            ArrayList<Message> mapList = new ArrayList<Message>();
            ArrayList<String> mapNames = new ArrayList<String>();
            for (DescriptorProtos.DescriptorProto nestedDescriptorProto : this.messageDescriptor.getNestedTypeList()) {
                Message nestedMessage = Message.newBuilder(nestedDescriptorProto).build();
                if (nestedDescriptorProto.hasOptions() && nestedDescriptorProto.getOptions().hasMapEntry()) {
                    mapNames.add(nestedMessage.getMessageName());
                    if (nestedMessage.getMessageName().length() > 5) {
                        nestedMessage.setMessageName(nestedMessage.getMessageName().substring(0, nestedMessage.getMessageName().length() - 5).toLowerCase(Locale.getDefault()));
                    }
                    mapList.add(nestedMessage);
                    continue;
                }
                nestedMessageList.add(nestedMessage);
            }
            ArrayList<Field> fieldList = new ArrayList<Field>();
            HashMap<String, List> oneofFieldMap = new HashMap<String, List>();
            for (Object fieldDescriptorProto : this.messageDescriptor.getFieldList()) {
                Field field = Field.newBuilder((DescriptorProtos.FieldDescriptorProto)fieldDescriptorProto).build();
                if (fieldDescriptorProto.hasOneofIndex()) {
                    String oneofField = this.messageDescriptor.getOneofDecl(fieldDescriptorProto.getOneofIndex()).getName();
                    List oneofMessageList = oneofFieldMap.computeIfAbsent(oneofField, k -> new ArrayList());
                    oneofMessageList.add(field);
                    continue;
                }
                if (mapNames.contains(field.getFieldType())) continue;
                fieldList.add(field);
            }
            ArrayList<EnumMessage> enumList = new ArrayList<EnumMessage>();
            for (DescriptorProtos.EnumDescriptorProto enumDescriptorProto : this.messageDescriptor.getEnumTypeList()) {
                EnumMessage enumMessage = EnumMessage.newBuilder(enumDescriptorProto).build();
                enumList.add(enumMessage);
            }
            Message message = new Message(this.messageDescriptor.getName(), fieldList);
            if (!oneofFieldMap.isEmpty()) {
                message.setOneofFieldMap(oneofFieldMap);
            }
            if (!enumList.isEmpty()) {
                message.setEnumList(enumList);
            }
            if (!nestedMessageList.isEmpty()) {
                message.setNestedMessageList(nestedMessageList);
            }
            if (!mapList.isEmpty()) {
                message.setMapList(mapList);
            }
            return message;
        }

        private Builder(DescriptorProtos.DescriptorProto messageDescriptor) {
            this.messageDescriptor = messageDescriptor;
        }
    }
}

