/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.nativeimpl.client;

import com.google.protobuf.Descriptors;
import io.netty.handler.codec.http.HttpHeaders;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.ballerinalang.jvm.BRuntime;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.scheduling.State;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.connector.NonBlockingCallback;
import org.ballerinalang.net.grpc.DataContext;
import org.ballerinalang.net.grpc.GrpcConstants;
import org.ballerinalang.net.grpc.GrpcUtil;
import org.ballerinalang.net.grpc.Message;
import org.ballerinalang.net.grpc.MessageUtils;
import org.ballerinalang.net.grpc.MethodDescriptor;
import org.ballerinalang.net.grpc.ServiceDefinition;
import org.ballerinalang.net.grpc.Status;
import org.ballerinalang.net.grpc.StreamObserver;
import org.ballerinalang.net.grpc.exception.GrpcClientException;
import org.ballerinalang.net.grpc.exception.StatusRuntimeException;
import org.ballerinalang.net.grpc.nativeimpl.client.AbstractExecute;
import org.ballerinalang.net.grpc.stubs.BlockingStub;
import org.ballerinalang.net.grpc.stubs.DefaultStreamObserver;
import org.ballerinalang.net.grpc.stubs.NonBlockingStub;
import org.ballerinalang.net.http.HttpConnectionManager;
import org.ballerinalang.net.http.HttpUtil;
import org.wso2.transport.http.netty.contract.HttpClientConnector;
import org.wso2.transport.http.netty.contract.config.SenderConfiguration;
import org.wso2.transport.http.netty.contract.config.TransportsConfiguration;
import org.wso2.transport.http.netty.contractimpl.sender.channel.pool.ConnectionManager;
import org.wso2.transport.http.netty.contractimpl.sender.channel.pool.PoolConfiguration;
import org.wso2.transport.http.netty.message.HttpConnectorUtil;

public class FunctionUtils
extends AbstractExecute {
    public static void externInitGlobalPool(ObjectValue endpointObject, MapValue<String, Long> globalPoolConfig) {
        PoolConfiguration globalPool = new PoolConfiguration();
        GrpcUtil.populatePoolingConfig(globalPoolConfig, globalPool);
        ConnectionManager connectionManager = new ConnectionManager(globalPool);
        globalPoolConfig.addNativeData("ConnectionManager", (Object)connectionManager);
    }

    public static Object externInit(ObjectValue clientEndpoint, String urlString, MapValue clientEndpointConfig, MapValue globalPoolConfig) {
        URL url;
        HttpConnectionManager connectionManager = HttpConnectionManager.getInstance();
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            return MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("Malformed URL: " + urlString)));
        }
        String scheme = url.getProtocol();
        Map properties = HttpConnectorUtil.getTransportProperties((TransportsConfiguration)connectionManager.getTransportConfig());
        SenderConfiguration senderConfiguration = HttpConnectorUtil.getSenderConfiguration((TransportsConfiguration)connectionManager.getTransportConfig(), (String)scheme);
        if (connectionManager.isHTTPTraceLoggerEnabled()) {
            senderConfiguration.setHttpTraceLogEnabled(true);
        }
        senderConfiguration.setTLSStoreType("PKCS12");
        try {
            GrpcUtil.populateSenderConfigurations(senderConfiguration, (MapValue<String, Object>)clientEndpointConfig, scheme);
            MapValue userDefinedPoolConfig = (MapValue)clientEndpointConfig.get((Object)"poolConfig");
            ConnectionManager poolManager = userDefinedPoolConfig == null ? GrpcUtil.getConnectionManager((MapValue<String, Long>)globalPoolConfig) : GrpcUtil.getConnectionManager((MapValue<String, Long>)userDefinedPoolConfig);
            senderConfiguration.setHttpVersion("2.0");
            senderConfiguration.setForceHttp2(true);
            HttpClientConnector clientConnector = HttpUtil.createHttpWsConnectionFactory().createHttpClientConnector(properties, senderConfiguration, poolManager);
            clientEndpoint.addNativeData("ClientConnector", (Object)clientConnector);
            clientEndpoint.addNativeData("url", (Object)urlString);
        }
        catch (ErrorValue ex) {
            return ex;
        }
        catch (RuntimeException ex) {
            return MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withCause(ex)));
        }
        return null;
    }

    public static Object externInitStub(ObjectValue genericEndpoint, ObjectValue clientEndpoint, String stubType, String rootDescriptor, MapValue<String, Object> descriptorMap) {
        block5: {
            HttpClientConnector clientConnector = (HttpClientConnector)genericEndpoint.getNativeData("ClientConnector");
            String urlString = (String)genericEndpoint.getNativeData("url");
            if (stubType == null || rootDescriptor == null || descriptorMap == null) {
                return MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("Error while initializing connector. message descriptor keys not exist. Please check the generated sub file")));
            }
            try {
                ServiceDefinition serviceDefinition = new ServiceDefinition(rootDescriptor, descriptorMap);
                Map<String, MethodDescriptor> methodDescriptorMap = serviceDefinition.getMethodDescriptors(clientEndpoint.getType());
                genericEndpoint.addNativeData("MethodDescriptors", methodDescriptorMap);
                if ("blocking".equalsIgnoreCase(stubType)) {
                    BlockingStub blockingStub = new BlockingStub(clientConnector, urlString);
                    genericEndpoint.addNativeData("Stub", (Object)blockingStub);
                    break block5;
                }
                if ("non-blocking".equalsIgnoreCase(stubType)) {
                    NonBlockingStub nonBlockingStub = new NonBlockingStub(clientConnector, urlString);
                    genericEndpoint.addNativeData("Stub", (Object)nonBlockingStub);
                    break block5;
                }
                return MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("Error while initializing connector. invalid connector type")));
            }
            catch (RuntimeException | GrpcClientException e) {
                return MessageUtils.getConnectorError(e);
            }
        }
        return null;
    }

    public static Object externBlockingExecute(ObjectValue clientEndpoint, String methodName, Object payloadBValue, Object headerValues) {
        Descriptors.MethodDescriptor methodDescriptor;
        if (clientEndpoint == null) {
            return FunctionUtils.notifyErrorReply(Status.Code.INTERNAL, "Error while getting connector. gRPC client connector is not initialized properly");
        }
        Object connectionStub = clientEndpoint.getNativeData("Stub");
        if (connectionStub == null) {
            return FunctionUtils.notifyErrorReply(Status.Code.INTERNAL, "Error while getting connection stub. gRPC Client connector is not initialized properly");
        }
        if (methodName == null) {
            return FunctionUtils.notifyErrorReply(Status.Code.INTERNAL, "Error while processing the request. RPC endpoint doesn't set properly");
        }
        Map methodDescriptors = (Map)clientEndpoint.getNativeData("MethodDescriptors");
        if (methodDescriptors == null) {
            return FunctionUtils.notifyErrorReply(Status.Code.INTERNAL, "Error while processing the request. method descriptors doesn't set properly");
        }
        Descriptors.MethodDescriptor methodDescriptor2 = methodDescriptor = methodDescriptors.get(methodName) != null ? ((MethodDescriptor)methodDescriptors.get(methodName)).getSchemaDescriptor() : null;
        if (methodDescriptor == null) {
            return FunctionUtils.notifyErrorReply(Status.Code.INTERNAL, "No registered method descriptor for '" + methodName + "'");
        }
        if (connectionStub instanceof BlockingStub) {
            Message requestMsg = new Message(methodDescriptor.getInputType().getName(), payloadBValue);
            HttpHeaders headers = null;
            if (headerValues != null && TypeChecker.getType((Object)headerValues).getTag() == 34) {
                headers = (HttpHeaders)((ObjectValue)headerValues).getNativeData("MessageHeaders");
            }
            if (headers != null) {
                requestMsg.setHeaders(headers);
            }
            BlockingStub blockingStub = (BlockingStub)connectionStub;
            DataContext dataContext = null;
            try {
                MethodDescriptor.MethodType methodType = FunctionUtils.getMethodType(methodDescriptor);
                if (!methodType.equals((Object)MethodDescriptor.MethodType.UNARY)) {
                    return FunctionUtils.notifyErrorReply(Status.Code.INTERNAL, "Error while executing the client call. Method type " + methodType.name() + " not supported");
                }
                dataContext = new DataContext(Scheduler.getStrand(), new NonBlockingCallback(Scheduler.getStrand()));
                blockingStub.executeUnary(requestMsg, (MethodDescriptor)methodDescriptors.get(methodName), dataContext);
            }
            catch (Exception e) {
                if (dataContext != null) {
                    FunctionUtils.unBlockStrand(dataContext.getStrand());
                }
                return FunctionUtils.notifyErrorReply(Status.Code.INTERNAL, "gRPC Client Connector Error :" + e.getMessage());
            }
        } else {
            return FunctionUtils.notifyErrorReply(Status.Code.INTERNAL, "Error while processing the request message. Connection Sub type not supported");
        }
        return null;
    }

    private static void unBlockStrand(Strand strand) {
        strand.setState(State.RUNNABLE);
        strand.blockedOnExtern = false;
    }

    public static Object externNonBlockingExecute(ObjectValue clientEndpoint, String methodName, Object payload, ObjectValue callbackService, Object headerValues) {
        Descriptors.MethodDescriptor methodDescriptor;
        if (clientEndpoint == null) {
            return FunctionUtils.notifyErrorReply(Status.Code.INTERNAL, "Error while getting connector. gRPC Client connector is not initialized properly");
        }
        Object connectionStub = clientEndpoint.getNativeData("Stub");
        if (connectionStub == null) {
            return FunctionUtils.notifyErrorReply(Status.Code.INTERNAL, "Error while getting connection stub. gRPC Client connector is not initialized properly");
        }
        if (methodName == null) {
            return FunctionUtils.notifyErrorReply(Status.Code.INTERNAL, "Error while processing the request. RPC endpoint doesn't set properly");
        }
        Map methodDescriptors = (Map)clientEndpoint.getNativeData("MethodDescriptors");
        if (methodDescriptors == null) {
            return FunctionUtils.notifyErrorReply(Status.Code.INTERNAL, "Error while processing the request. method descriptors doesn't set properly");
        }
        Descriptors.MethodDescriptor methodDescriptor2 = methodDescriptor = methodDescriptors.get(methodName) != null ? ((MethodDescriptor)methodDescriptors.get(methodName)).getSchemaDescriptor() : null;
        if (methodDescriptor == null) {
            return FunctionUtils.notifyErrorReply(Status.Code.INTERNAL, "No registered method descriptor for '" + methodName + "'");
        }
        if (connectionStub instanceof NonBlockingStub) {
            Message requestMsg = new Message(methodDescriptor.getInputType().getName(), payload);
            HttpHeaders headers = null;
            if (headerValues != null && TypeChecker.getType((Object)headerValues).getTag() == 34) {
                headers = (HttpHeaders)((ObjectValue)headerValues).getNativeData("MessageHeaders");
            }
            if (headers != null) {
                requestMsg.setHeaders(headers);
            }
            NonBlockingStub nonBlockingStub = (NonBlockingStub)connectionStub;
            try {
                MethodDescriptor.MethodType methodType = FunctionUtils.getMethodType(methodDescriptor);
                DataContext context = new DataContext(Scheduler.getStrand(), null);
                if (methodType.equals((Object)MethodDescriptor.MethodType.UNARY)) {
                    nonBlockingStub.executeUnary(requestMsg, new DefaultStreamObserver(BRuntime.getCurrentRuntime(), callbackService), (MethodDescriptor)methodDescriptors.get(methodName), context);
                } else if (methodType.equals((Object)MethodDescriptor.MethodType.SERVER_STREAMING)) {
                    nonBlockingStub.executeServerStreaming(requestMsg, new DefaultStreamObserver(BRuntime.getCurrentRuntime(), callbackService), (MethodDescriptor)methodDescriptors.get(methodName), context);
                } else {
                    return FunctionUtils.notifyErrorReply(Status.Code.INTERNAL, "Error while executing the client call. Method type " + methodType.name() + " not supported");
                }
                return null;
            }
            catch (Exception e) {
                return FunctionUtils.notifyErrorReply(Status.Code.INTERNAL, "gRPC Client Connector Error :" + e.getMessage());
            }
        }
        return FunctionUtils.notifyErrorReply(Status.Code.INTERNAL, "Error while processing the request message. Connection Sub type not supported");
    }

    public static Object externStreamingExecute(ObjectValue clientEndpoint, String methodName, ObjectValue callbackService, Object headerValues) {
        Descriptors.MethodDescriptor methodDescriptor;
        if (clientEndpoint == null) {
            return FunctionUtils.notifyErrorReply(Status.Code.INTERNAL, "Error while getting connector. gRPC Client connector is not initialized properly");
        }
        Object connectionStub = clientEndpoint.getNativeData("Stub");
        if (connectionStub == null) {
            return FunctionUtils.notifyErrorReply(Status.Code.INTERNAL, "Error while getting connection stub. gRPC Client connector is not initialized properly");
        }
        if (methodName == null) {
            return FunctionUtils.notifyErrorReply(Status.Code.INTERNAL, "Error while processing the request. RPC endpoint doesn't set properly");
        }
        Map methodDescriptors = (Map)clientEndpoint.getNativeData("MethodDescriptors");
        if (methodDescriptors == null) {
            return FunctionUtils.notifyErrorReply(Status.Code.INTERNAL, "Error while processing the request. method descriptors doesn't set properly");
        }
        Descriptors.MethodDescriptor methodDescriptor2 = methodDescriptor = methodDescriptors.get(methodName) != null ? ((MethodDescriptor)methodDescriptors.get(methodName)).getSchemaDescriptor() : null;
        if (methodDescriptor == null) {
            return FunctionUtils.notifyErrorReply(Status.Code.INTERNAL, "No registered method descriptor for '" + methodName + "'");
        }
        if (connectionStub instanceof NonBlockingStub) {
            NonBlockingStub nonBlockingStub = (NonBlockingStub)connectionStub;
            HttpHeaders headers = null;
            if (headerValues != null && TypeChecker.getType((Object)headerValues).getTag() == 34) {
                headers = (HttpHeaders)((ObjectValue)headerValues).getNativeData("MessageHeaders");
            }
            try {
                StreamObserver requestSender;
                MethodDescriptor.MethodType methodType = FunctionUtils.getMethodType(methodDescriptor);
                DefaultStreamObserver responseObserver = new DefaultStreamObserver(BRuntime.getCurrentRuntime(), callbackService);
                DataContext context = new DataContext(Scheduler.getStrand(), null);
                if (methodType.equals((Object)MethodDescriptor.MethodType.CLIENT_STREAMING)) {
                    requestSender = nonBlockingStub.executeClientStreaming(headers, responseObserver, (MethodDescriptor)methodDescriptors.get(methodName), context);
                } else if (methodType.equals((Object)MethodDescriptor.MethodType.BIDI_STREAMING)) {
                    requestSender = nonBlockingStub.executeBidiStreaming(headers, responseObserver, (MethodDescriptor)methodDescriptors.get(methodName), context);
                } else {
                    return FunctionUtils.notifyErrorReply(Status.Code.INTERNAL, "Error while executing the client call. Method type " + methodType.name() + " not supported");
                }
                ObjectValue streamingConnection = BallerinaValues.createObjectValue((BPackage)GrpcConstants.PROTOCOL_GRPC_PKG_ID, (String)"StreamingClient", (Object[])new Object[0]);
                streamingConnection.addNativeData("REQUEST_SENDER", (Object)requestSender);
                streamingConnection.addNativeData("REQUEST_DEFINITION", (Object)methodDescriptor.getInputType());
                return streamingConnection;
            }
            catch (RuntimeException | GrpcClientException e) {
                return FunctionUtils.notifyErrorReply(Status.Code.INTERNAL, "gRPC Client Connector Error :" + e.getMessage());
            }
        }
        return FunctionUtils.notifyErrorReply(Status.Code.INTERNAL, "Error while processing the request message. Connection Sub type not supported");
    }
}

