/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.proto.definition;

import com.google.protobuf.DescriptorProtos;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.net.grpc.proto.ServiceProtoConstants;
import org.ballerinalang.net.grpc.proto.definition.Method;

public class Service {
    private DescriptorProtos.ServiceDescriptorProto serviceDescriptor;
    private List<Method> methodList = new ArrayList<Method>();

    private Service(DescriptorProtos.ServiceDescriptorProto serviceDescriptor) {
        this.serviceDescriptor = serviceDescriptor;
    }

    public static Builder newBuilder(String serviceName) {
        return new Builder(serviceName);
    }

    public DescriptorProtos.ServiceDescriptorProto getServiceDescriptor() {
        return this.serviceDescriptor;
    }

    public String getServiceDefinition() {
        StringBuilder serviceDefinition = new StringBuilder();
        serviceDefinition.append("service ").append(this.serviceDescriptor.getName()).append(" {").append(ServiceProtoConstants.NEW_LINE_CHARACTER);
        for (Method method : this.methodList) {
            serviceDefinition.append("\t").append(method.getMethodDefinition());
        }
        serviceDefinition.append("}").append(ServiceProtoConstants.NEW_LINE_CHARACTER);
        return serviceDefinition.toString();
    }

    public static class Builder {
        private DescriptorProtos.ServiceDescriptorProto.Builder serviceBuilder;
        private List<Method> methodList = new ArrayList<Method>();

        public Builder addMethod(Method methodDefinition) {
            this.methodList.add(methodDefinition);
            this.serviceBuilder.addMethod(methodDefinition.getMethodDescriptor());
            return this;
        }

        public Service build() {
            Service service = new Service(this.serviceBuilder.build());
            service.methodList = this.methodList;
            return service;
        }

        private Builder(String serviceName) {
            this.serviceBuilder = DescriptorProtos.ServiceDescriptorProto.newBuilder();
            this.serviceBuilder.setName(serviceName);
        }
    }
}

