/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.ballerinalang.config.ConfigRegistry;
import org.ballerinalang.jvm.util.exceptions.BallerinaConnectorException;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.api.BString;
import org.ballerinalang.net.grpc.MessageUtils;
import org.ballerinalang.net.grpc.Status;
import org.ballerinalang.net.grpc.exception.StatusRuntimeException;
import org.ballerinalang.net.http.HttpConstants;
import org.ballerinalang.net.http.HttpUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.config.ListenerConfiguration;
import org.wso2.transport.http.netty.contract.config.Parameter;
import org.wso2.transport.http.netty.contract.config.SenderConfiguration;
import org.wso2.transport.http.netty.contract.config.SslConfiguration;
import org.wso2.transport.http.netty.contractimpl.sender.channel.pool.ConnectionManager;
import org.wso2.transport.http.netty.contractimpl.sender.channel.pool.PoolConfiguration;

public class GrpcUtil {
    private static final Logger log = LoggerFactory.getLogger(GrpcUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectionManager getConnectionManager(MapValue<BString, Long> poolStruct) {
        ConnectionManager poolManager = (ConnectionManager)poolStruct.getNativeData("ConnectionManager");
        if (poolManager == null) {
            MapValue<BString, Long> mapValue = poolStruct;
            synchronized (mapValue) {
                if (poolStruct.getNativeData("ConnectionManager") == null) {
                    PoolConfiguration userDefinedPool = new PoolConfiguration();
                    GrpcUtil.populatePoolingConfig(poolStruct, userDefinedPool);
                    poolManager = new ConnectionManager(userDefinedPool);
                    poolStruct.addNativeData("ConnectionManager", (Object)poolManager);
                }
            }
        }
        return poolManager;
    }

    public static void populatePoolingConfig(MapValue<BString, Long> poolRecord, PoolConfiguration poolConfiguration) {
        long maxActiveConnections = (Long)poolRecord.get((Object)HttpConstants.CONNECTION_POOLING_MAX_ACTIVE_CONNECTIONS);
        poolConfiguration.setMaxActivePerPool(GrpcUtil.validateConfig(maxActiveConnections, HttpConstants.CONNECTION_POOLING_MAX_ACTIVE_CONNECTIONS));
        long maxIdleConnections = (Long)poolRecord.get((Object)HttpConstants.CONNECTION_POOLING_MAX_IDLE_CONNECTIONS);
        poolConfiguration.setMaxIdlePerPool(GrpcUtil.validateConfig(maxIdleConnections, HttpConstants.CONNECTION_POOLING_MAX_IDLE_CONNECTIONS));
        long waitTime = (Long)poolRecord.get((Object)HttpConstants.CONNECTION_POOLING_WAIT_TIME);
        poolConfiguration.setMaxWaitTime(waitTime);
        long maxActiveStreamsPerConnection = (Long)poolRecord.get((Object)HttpConstants.CONNECTION_POOLING_MAX_ACTIVE_STREAMS_PER_CONNECTION);
        poolConfiguration.setHttp2MaxActiveStreamsPerConnection(maxActiveStreamsPerConnection == -1L ? Integer.MAX_VALUE : GrpcUtil.validateConfig(maxActiveStreamsPerConnection, HttpConstants.CONNECTION_POOLING_MAX_ACTIVE_STREAMS_PER_CONNECTION));
    }

    public static void populateSenderConfigurations(SenderConfiguration senderConfiguration, MapValue<BString, Object> clientEndpointConfig, String scheme) {
        MapValue secureSocket = clientEndpointConfig.getMapValue(HttpConstants.ENDPOINT_CONFIG_SECURE_SOCKET);
        if (secureSocket != null) {
            GrpcUtil.populateSSLConfiguration((SslConfiguration)senderConfiguration, (MapValue<BString, Object>)secureSocket);
        } else if (scheme.equals("https")) {
            throw MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("To enable https you need to configure secureSocket record")));
        }
        long timeoutMillis = clientEndpointConfig.getIntValue(HttpConstants.CLIENT_EP_ENDPOINT_TIMEOUT);
        if (timeoutMillis < 0L) {
            senderConfiguration.setSocketIdleTimeout(0);
        } else {
            senderConfiguration.setSocketIdleTimeout(GrpcUtil.validateConfig(timeoutMillis, HttpConstants.CLIENT_EP_ENDPOINT_TIMEOUT));
        }
    }

    public static void populateSSLConfiguration(SslConfiguration sslConfiguration, MapValue<BString, Object> secureSocket) {
        List<String> ciphersValueList;
        MapValue trustStore = secureSocket.getMapValue(HttpConstants.ENDPOINT_CONFIG_TRUST_STORE);
        MapValue keyStore = secureSocket.getMapValue(HttpConstants.ENDPOINT_CONFIG_KEY_STORE);
        MapValue protocols = secureSocket.getMapValue(HttpConstants.ENDPOINT_CONFIG_PROTOCOLS);
        MapValue validateCert = secureSocket.getMapValue(HttpConstants.ENDPOINT_CONFIG_VALIDATE_CERT);
        String keyFile = secureSocket.getStringValue(HttpConstants.ENDPOINT_CONFIG_KEY).getValue();
        String certFile = secureSocket.getStringValue(HttpConstants.ENDPOINT_CONFIG_CERTIFICATE).getValue();
        String trustCerts = secureSocket.getStringValue(HttpConstants.ENDPOINT_CONFIG_TRUST_CERTIFICATES).getValue();
        String keyPassword = secureSocket.getStringValue(HttpConstants.ENDPOINT_CONFIG_KEY_PASSWORD).getValue();
        boolean disableSslValidation = secureSocket.getBooleanValue(HttpConstants.ENDPOINT_CONFIG_DISABLE_SSL);
        ArrayList<Parameter> clientParams = new ArrayList<Parameter>();
        if (disableSslValidation) {
            sslConfiguration.disableSsl();
            return;
        }
        if (trustStore != null && StringUtils.isNotBlank((CharSequence)trustCerts)) {
            throw MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("Cannot configure both trustStore and trustCerts at the same time.")));
        }
        if (trustStore != null) {
            String trustStorePassword;
            String trustStoreFile = trustStore.getStringValue(HttpConstants.FILE_PATH).getValue();
            if (StringUtils.isNotBlank((CharSequence)trustStoreFile)) {
                sslConfiguration.setTrustStoreFile(trustStoreFile);
            }
            if (StringUtils.isNotBlank((CharSequence)(trustStorePassword = trustStore.getStringValue(HttpConstants.PASSWORD).getValue()))) {
                sslConfiguration.setTrustStorePass(trustStorePassword);
            }
        } else if (StringUtils.isNotBlank((CharSequence)trustCerts)) {
            sslConfiguration.setClientTrustCertificates(trustCerts);
        }
        if (keyStore != null && StringUtils.isNotBlank((CharSequence)keyFile)) {
            throw MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("Cannot configure both keyStore and keyFile.")));
        }
        if (StringUtils.isNotBlank((CharSequence)keyFile) && StringUtils.isBlank((CharSequence)certFile)) {
            throw MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("Need to configure certFile containing client ssl certificates.")));
        }
        if (keyStore != null) {
            String keyStorePassword;
            String keyStoreFile = keyStore.getStringValue(HttpConstants.FILE_PATH).getValue();
            if (StringUtils.isNotBlank((CharSequence)keyStoreFile)) {
                sslConfiguration.setKeyStoreFile(keyStoreFile);
            }
            if (StringUtils.isNotBlank((CharSequence)(keyStorePassword = keyStore.getStringValue(HttpConstants.PASSWORD).getValue()))) {
                sslConfiguration.setKeyStorePass(keyStorePassword);
            }
        } else if (StringUtils.isNotBlank((CharSequence)keyFile)) {
            sslConfiguration.setClientKeyFile(keyFile);
            sslConfiguration.setClientCertificates(certFile);
            if (StringUtils.isNotBlank((CharSequence)keyPassword)) {
                sslConfiguration.setClientKeyPassword(keyPassword);
            }
        }
        if (protocols != null) {
            String sslProtocol;
            List<String> sslEnabledProtocolsValueList = Arrays.asList(protocols.getArrayValue(HttpConstants.ENABLED_PROTOCOLS).getStringArray());
            if (!sslEnabledProtocolsValueList.isEmpty()) {
                String sslEnabledProtocols = sslEnabledProtocolsValueList.stream().collect(Collectors.joining(",", "", ""));
                Parameter clientProtocols = new Parameter("sslEnabledProtocols", sslEnabledProtocols);
                clientParams.add(clientProtocols);
            }
            if (StringUtils.isNotBlank((CharSequence)(sslProtocol = protocols.getStringValue(HttpConstants.SSL_PROTOCOL_VERSION).getValue()))) {
                sslConfiguration.setSSLProtocol(sslProtocol);
            }
        }
        if (validateCert != null) {
            boolean validateCertEnabled = validateCert.getBooleanValue(HttpConstants.ENABLE);
            int cacheSize = validateCert.getIntValue(HttpConstants.SSL_CONFIG_CACHE_SIZE).intValue();
            int cacheValidityPeriod = validateCert.getIntValue(HttpConstants.SSL_CONFIG_CACHE_VALIDITY_PERIOD).intValue();
            sslConfiguration.setValidateCertEnabled(validateCertEnabled);
            if (cacheValidityPeriod != 0) {
                sslConfiguration.setCacheValidityPeriod(cacheValidityPeriod);
            }
            if (cacheSize != 0) {
                sslConfiguration.setCacheSize(cacheSize);
            }
        }
        boolean hostNameVerificationEnabled = secureSocket.getBooleanValue(HttpConstants.SSL_CONFIG_HOST_NAME_VERIFICATION_ENABLED);
        boolean ocspStaplingEnabled = secureSocket.getBooleanValue(HttpConstants.ENDPOINT_CONFIG_OCSP_STAPLING);
        sslConfiguration.setOcspStaplingEnabled(ocspStaplingEnabled);
        sslConfiguration.setHostNameVerificationEnabled(hostNameVerificationEnabled);
        sslConfiguration.setSslSessionTimeOut((int)secureSocket.getDefaultableIntValue(HttpConstants.ENDPOINT_CONFIG_SESSION_TIMEOUT));
        sslConfiguration.setSslHandshakeTimeOut(secureSocket.getDefaultableIntValue(HttpConstants.ENDPOINT_CONFIG_HANDSHAKE_TIMEOUT));
        String[] cipherConfigs = secureSocket.getArrayValue(HttpConstants.SSL_CONFIG_CIPHERS).getStringArray();
        if (cipherConfigs != null && (ciphersValueList = Arrays.asList(cipherConfigs)).size() > 0) {
            String ciphers = ciphersValueList.stream().map(Object::toString).collect(Collectors.joining(",", "", ""));
            Parameter clientCiphers = new Parameter("ciphers", ciphers);
            clientParams.add(clientCiphers);
        }
        String enableSessionCreation = String.valueOf(secureSocket.getBooleanValue(HttpConstants.SSL_CONFIG_ENABLE_SESSION_CREATION));
        Parameter clientEnableSessionCreation = new Parameter(HttpConstants.SSL_CONFIG_ENABLE_SESSION_CREATION.getValue(), enableSessionCreation);
        clientParams.add(clientEnableSessionCreation);
        if (!clientParams.isEmpty()) {
            sslConfiguration.setParameters(clientParams);
        }
    }

    public static ListenerConfiguration getListenerConfig(long port, MapValue<BString, Object> endpointConfig) {
        BString host = endpointConfig.getStringValue(HttpConstants.ENDPOINT_CONFIG_HOST);
        MapValue sslConfig = endpointConfig.getMapValue(HttpConstants.ENDPOINT_CONFIG_SECURE_SOCKET);
        long idleTimeout = endpointConfig.getIntValue(HttpConstants.ENDPOINT_CONFIG_TIMEOUT);
        ListenerConfiguration listenerConfiguration = new ListenerConfiguration();
        if (host == null || host.getValue().trim().isEmpty()) {
            listenerConfiguration.setHost(ConfigRegistry.getInstance().getConfigOrDefault("b7a.http.host", "0.0.0.0"));
        } else {
            listenerConfiguration.setHost(host.getValue());
        }
        if (port == 0L) {
            throw new BallerinaConnectorException("Listener port is not defined!");
        }
        listenerConfiguration.setPort(Math.toIntExact(port));
        if (idleTimeout < 0L) {
            throw new BallerinaConnectorException("Idle timeout cannot be negative. If you want to disable the timeout please use value 0");
        }
        listenerConfiguration.setSocketIdleTimeout(Math.toIntExact(idleTimeout));
        listenerConfiguration.setVersion("2.0");
        if (endpointConfig.getType().getName().equalsIgnoreCase("ListenerConfiguration")) {
            BString serverName = endpointConfig.getStringValue(HttpConstants.SERVER_NAME);
            listenerConfiguration.setServerHeader(serverName != null ? serverName.getValue() : GrpcUtil.getServerName());
        } else {
            listenerConfiguration.setServerHeader(GrpcUtil.getServerName());
        }
        if (sslConfig != null) {
            return GrpcUtil.setSslConfig((MapValue<BString, Object>)sslConfig, listenerConfiguration);
        }
        listenerConfiguration.setPipeliningEnabled(true);
        return listenerConfiguration;
    }

    private static String getServerName() {
        String version = System.getProperty("ballerina.version");
        String userAgent = version != null ? "ballerina/" + version : "ballerina";
        return userAgent;
    }

    private static ListenerConfiguration setSslConfig(MapValue<BString, Object> sslConfig, ListenerConfiguration listenerConfiguration) {
        long cacheValidationPeriod;
        long cacheSize;
        List<String> ciphersValueList;
        Parameter serverParameters;
        String keyPassword;
        listenerConfiguration.setScheme("https");
        MapValue trustStore = sslConfig.getMapValue(HttpConstants.ENDPOINT_CONFIG_TRUST_STORE);
        MapValue keyStore = sslConfig.getMapValue(HttpConstants.ENDPOINT_CONFIG_KEY_STORE);
        MapValue protocols = sslConfig.getMapValue(HttpConstants.ENDPOINT_CONFIG_PROTOCOLS);
        MapValue validateCert = sslConfig.getMapValue(HttpConstants.ENDPOINT_CONFIG_VALIDATE_CERT);
        MapValue ocspStapling = sslConfig.getMapValue(HttpConstants.ENDPOINT_CONFIG_OCSP_STAPLING);
        String keyFile = sslConfig.getStringValue(HttpConstants.ENDPOINT_CONFIG_KEY) != null ? sslConfig.getStringValue(HttpConstants.ENDPOINT_CONFIG_KEY).getValue() : null;
        String certFile = sslConfig.getStringValue(HttpConstants.ENDPOINT_CONFIG_CERTIFICATE) != null ? sslConfig.getStringValue(HttpConstants.ENDPOINT_CONFIG_CERTIFICATE).getValue() : null;
        String trustCerts = sslConfig.getStringValue(HttpConstants.ENDPOINT_CONFIG_TRUST_CERTIFICATES) != null ? sslConfig.getStringValue(HttpConstants.ENDPOINT_CONFIG_TRUST_CERTIFICATES).getValue() : null;
        String string = keyPassword = sslConfig.getStringValue(HttpConstants.ENDPOINT_CONFIG_KEY_PASSWORD) != null ? sslConfig.getStringValue(HttpConstants.ENDPOINT_CONFIG_KEY_PASSWORD).getValue() : null;
        if (keyStore != null && StringUtils.isNotBlank((CharSequence)keyFile)) {
            throw MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("Cannot configure both keyStore and keyFile at the same time.")));
        }
        if (keyStore == null && (StringUtils.isBlank((CharSequence)keyFile) || StringUtils.isBlank((CharSequence)certFile))) {
            throw MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("Either keystore or certificateKey and server certificates must be provided for secure connection")));
        }
        if (keyStore != null) {
            String keyStorePassword;
            String keyStoreFile;
            String string2 = keyStoreFile = keyStore.getStringValue(HttpConstants.FILE_PATH) != null ? keyStore.getStringValue(HttpConstants.FILE_PATH).getValue() : null;
            if (StringUtils.isBlank((CharSequence)keyStoreFile)) {
                throw MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("Keystore file location must be provided for secure connection.")));
            }
            String string3 = keyStorePassword = keyStore.getStringValue(HttpConstants.PASSWORD) != null ? keyStore.getStringValue(HttpConstants.PASSWORD).getValue() : null;
            if (StringUtils.isBlank((CharSequence)keyStorePassword)) {
                throw MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("Keystore password must be provided for secure connection")));
            }
            listenerConfiguration.setKeyStoreFile(keyStoreFile);
            listenerConfiguration.setKeyStorePass(keyStorePassword);
        } else {
            listenerConfiguration.setServerKeyFile(keyFile);
            listenerConfiguration.setServerCertificates(certFile);
            if (StringUtils.isNotBlank((CharSequence)keyPassword)) {
                listenerConfiguration.setServerKeyPassword(keyPassword);
            }
        }
        String sslVerifyClient = sslConfig.getStringValue(HttpConstants.SSL_CONFIG_SSL_VERIFY_CLIENT) != null ? sslConfig.getStringValue(HttpConstants.SSL_CONFIG_SSL_VERIFY_CLIENT).getValue() : null;
        listenerConfiguration.setVerifyClient(sslVerifyClient);
        listenerConfiguration.setSslSessionTimeOut((int)sslConfig.getDefaultableIntValue(HttpConstants.ENDPOINT_CONFIG_SESSION_TIMEOUT));
        listenerConfiguration.setSslHandshakeTimeOut(sslConfig.getDefaultableIntValue(HttpConstants.ENDPOINT_CONFIG_HANDSHAKE_TIMEOUT));
        if (trustStore == null && StringUtils.isNotBlank((CharSequence)sslVerifyClient) && StringUtils.isBlank((CharSequence)trustCerts)) {
            throw MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("Truststore location or trustCertificates must be provided to enable Mutual SSL")));
        }
        if (trustStore != null) {
            String trustStorePassword;
            String trustStoreFile = trustStore.getStringValue(HttpConstants.FILE_PATH) != null ? trustStore.getStringValue(HttpConstants.FILE_PATH).getValue() : null;
            String string4 = trustStorePassword = trustStore.getStringValue(HttpConstants.PASSWORD) != null ? trustStore.getStringValue(HttpConstants.PASSWORD).getValue() : null;
            if (StringUtils.isBlank((CharSequence)trustStoreFile) && StringUtils.isNotBlank((CharSequence)sslVerifyClient)) {
                throw MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("Truststore location must be provided to enable Mutual SSL")));
            }
            if (StringUtils.isBlank((CharSequence)trustStorePassword) && StringUtils.isNotBlank((CharSequence)sslVerifyClient)) {
                throw MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("Truststore password value must be provided to enable Mutual SSL")));
            }
            listenerConfiguration.setTrustStoreFile(trustStoreFile);
            listenerConfiguration.setTrustStorePass(trustStorePassword);
        } else if (StringUtils.isNotBlank((CharSequence)trustCerts)) {
            listenerConfiguration.setServerTrustCertificates(trustCerts);
        }
        ArrayList<Parameter> serverParamList = new ArrayList<Parameter>();
        if (protocols != null) {
            String sslProtocol;
            List<String> sslEnabledProtocolsValueList = Arrays.asList(protocols.getArrayValue(HttpConstants.ENABLED_PROTOCOLS).getStringArray());
            if (!sslEnabledProtocolsValueList.isEmpty()) {
                String sslEnabledProtocols = sslEnabledProtocolsValueList.stream().collect(Collectors.joining(",", "", ""));
                serverParameters = new Parameter("sslEnabledProtocols", sslEnabledProtocols);
                serverParamList.add(serverParameters);
            }
            String string5 = sslProtocol = protocols.getStringValue(HttpConstants.SSL_PROTOCOL_VERSION) != null ? protocols.getStringValue(HttpConstants.SSL_PROTOCOL_VERSION).getValue() : null;
            if (StringUtils.isNotBlank((CharSequence)sslProtocol)) {
                listenerConfiguration.setSSLProtocol(sslProtocol);
            }
        }
        if (!(ciphersValueList = Arrays.asList(sslConfig.getArrayValue(HttpConstants.SSL_CONFIG_CIPHERS).getStringArray())).isEmpty()) {
            String ciphers = ciphersValueList.stream().collect(Collectors.joining(",", "", ""));
            serverParameters = new Parameter("ciphers", ciphers);
            serverParamList.add(serverParameters);
        }
        if (validateCert != null) {
            boolean validateCertificateEnabled = validateCert.getBooleanValue(HttpConstants.ENABLE);
            cacheSize = validateCert.getIntValue(HttpConstants.SSL_CONFIG_CACHE_SIZE);
            cacheValidationPeriod = validateCert.getIntValue(HttpConstants.SSL_CONFIG_CACHE_VALIDITY_PERIOD);
            listenerConfiguration.setValidateCertEnabled(validateCertificateEnabled);
            if (validateCertificateEnabled) {
                if (cacheSize != 0L) {
                    listenerConfiguration.setCacheSize(Math.toIntExact(cacheSize));
                }
                if (cacheValidationPeriod != 0L) {
                    listenerConfiguration.setCacheValidityPeriod(Math.toIntExact(cacheValidationPeriod));
                }
            }
        }
        if (ocspStapling != null) {
            boolean ocspStaplingEnabled = ocspStapling.getBooleanValue(HttpConstants.ENABLE);
            listenerConfiguration.setOcspStaplingEnabled(ocspStaplingEnabled);
            cacheSize = ocspStapling.getIntValue(HttpConstants.SSL_CONFIG_CACHE_SIZE);
            cacheValidationPeriod = ocspStapling.getIntValue(HttpConstants.SSL_CONFIG_CACHE_VALIDITY_PERIOD);
            listenerConfiguration.setValidateCertEnabled(ocspStaplingEnabled);
            if (ocspStaplingEnabled) {
                if (cacheSize != 0L) {
                    listenerConfiguration.setCacheSize(Math.toIntExact(cacheSize));
                }
                if (cacheValidationPeriod != 0L) {
                    listenerConfiguration.setCacheValidityPeriod(Math.toIntExact(cacheValidationPeriod));
                }
            }
        }
        listenerConfiguration.setTLSStoreType("PKCS12");
        String serverEnableSessionCreation = String.valueOf(sslConfig.getBooleanValue(HttpConstants.SSL_CONFIG_ENABLE_SESSION_CREATION));
        Parameter enableSessionCreationParam = new Parameter(HttpConstants.SSL_CONFIG_ENABLE_SESSION_CREATION.getValue(), serverEnableSessionCreation);
        serverParamList.add(enableSessionCreationParam);
        if (!serverParamList.isEmpty()) {
            listenerConfiguration.setParameters(serverParamList);
        }
        listenerConfiguration.setId(HttpUtil.getListenerInterface((String)listenerConfiguration.getHost(), (int)listenerConfiguration.getPort()));
        return listenerConfiguration;
    }

    private static int validateConfig(long value, BString configName) {
        try {
            return Math.toIntExact(value);
        }
        catch (ArithmeticException e) {
            log.warn("The value set for the configuration needs to be less than {}. The " + configName.getValue() + "value is set to {}", (Object)Integer.MAX_VALUE);
            return Integer.MAX_VALUE;
        }
    }
}

