/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc;

import java.util.Optional;
import org.ballerinalang.jvm.observability.ObserveUtils;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.net.grpc.ClientCall;
import org.ballerinalang.net.grpc.ClientConnectorListener;
import org.ballerinalang.net.grpc.DataContext;
import org.ballerinalang.net.http.HttpConstants;
import org.wso2.transport.http.netty.contract.exceptions.ClientConnectorException;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class ObservableClientConnectorListener
extends ClientConnectorListener {
    private final DataContext context;

    public ObservableClientConnectorListener(ClientCall.ClientStreamListener streamListener, DataContext context) {
        super(streamListener);
        this.context = context;
    }

    @Override
    public void onMessage(HttpCarbonMessage httpCarbonMessage) {
        Integer statusCode = (Integer)httpCarbonMessage.getProperty(HttpConstants.RESPONSE_STATUS_CODE_FIELD.getValue());
        this.addHttpStatusCode(statusCode == null ? 0 : statusCode);
        super.onMessage(httpCarbonMessage);
    }

    @Override
    public void onError(Throwable throwable) {
        if (throwable instanceof ClientConnectorException) {
            ClientConnectorException clientConnectorException = (ClientConnectorException)throwable;
            this.addHttpStatusCode(clientConnectorException.getHttpStatusCode());
            Optional observerContext = ObserveUtils.getObserverContextOfCurrentFrame((Strand)this.context.getStrand());
            observerContext.ifPresent(ctx -> {
                ctx.addTag("error", "true");
                ctx.addProperty("error_message", (Object)throwable.getMessage());
            });
        }
        super.onError(throwable);
    }

    private void addHttpStatusCode(int statusCode) {
        Optional observerContext = ObserveUtils.getObserverContextOfCurrentFrame((Strand)this.context.getStrand());
        observerContext.ifPresent(ctx -> ctx.addProperty("http.status_code", (Object)statusCode));
    }
}

