/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc;

import com.google.protobuf.CodedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.ballerinalang.net.grpc.KnownLength;
import org.ballerinalang.net.grpc.Message;
import org.ballerinalang.net.grpc.MessageParser;
import org.ballerinalang.net.grpc.MethodDescriptor;
import org.ballerinalang.net.grpc.ProtoInputStream;
import org.ballerinalang.net.grpc.Status;

public class ProtoUtils {
    private static final int BUF_SIZE = 8192;
    private static final int DEFAULT_MAX_MESSAGE_SIZE = 0x400000;
    private static final ThreadLocal<Reference<byte[]>> bufs = ThreadLocal.withInitial(() -> new WeakReference<byte[]>(new byte[4096]));

    public static MethodDescriptor.Marshaller marshaller(final MessageParser instance) {
        final MessageParser parser = instance;
        return new MethodDescriptor.Marshaller(){

            @Override
            public InputStream stream(Message value) {
                return new ProtoInputStream(value);
            }

            @Override
            public Message parse(InputStream stream) {
                CodedInputStream cis = null;
                try {
                    if (stream instanceof KnownLength) {
                        int size = stream.available();
                        if (size > 0 && size <= 0x400000) {
                            int position;
                            int remaining;
                            int count;
                            byte[] buf = (byte[])((Reference)bufs.get()).get();
                            if (buf == null || buf.length < size) {
                                buf = new byte[size];
                                bufs.set(new WeakReference<byte[]>(buf));
                            }
                            for (remaining = size; remaining > 0 && (count = stream.read(buf, position = size - remaining, remaining)) != -1; remaining -= count) {
                            }
                            if (remaining != 0) {
                                position = size - remaining;
                                throw new RuntimeException("size inaccurate: " + size + " != " + position);
                            }
                            cis = CodedInputStream.newInstance((byte[])buf, (int)0, (int)size);
                        } else if (size == 0) {
                            return instance.getDefaultInstance();
                        }
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (cis == null) {
                    cis = CodedInputStream.newInstance((InputStream)stream);
                }
                cis.setSizeLimit(Integer.MAX_VALUE);
                try {
                    return this.parseFrom(cis);
                }
                catch (IOException ipbe) {
                    throw Status.Code.INTERNAL.toStatus().withDescription("Invalid protobuf byte sequence").withCause(ipbe).asRuntimeException();
                }
            }

            private Message parseFrom(CodedInputStream stream) throws IOException {
                Message message = parser.parseFrom(stream);
                stream.checkLastTagWas(0);
                return message;
            }
        };
    }

    static long copy(InputStream from, OutputStream to) throws IOException {
        int r;
        byte[] buf = new byte[8192];
        long total = 0L;
        while ((r = from.read(buf)) != -1) {
            to.write(buf, 0, r);
            total += (long)r;
        }
        return total;
    }

    private ProtoUtils() {
    }
}

