/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc;

import com.google.protobuf.ByteString;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.ballerinalang.jvm.StringUtils;
import org.ballerinalang.jvm.types.AttachedFunction;
import org.ballerinalang.jvm.types.BObjectType;
import org.ballerinalang.jvm.types.BTupleType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.types.BUnionType;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.api.BString;
import org.ballerinalang.net.grpc.MessageParser;
import org.ballerinalang.net.grpc.MessageRegistry;
import org.ballerinalang.net.grpc.MessageUtils;
import org.ballerinalang.net.grpc.MethodDescriptor;
import org.ballerinalang.net.grpc.ProtoUtils;
import org.ballerinalang.net.grpc.ServicesBuilderUtils;
import org.ballerinalang.net.grpc.exception.GrpcClientException;

public final class ServiceDefinition {
    private String rootDescriptor;
    private MapValue<BString, Object> descriptorMap;
    private Descriptors.FileDescriptor fileDescriptor;

    public ServiceDefinition(String rootDescriptor, MapValue<BString, Object> descriptorMap) {
        this.rootDescriptor = rootDescriptor;
        this.descriptorMap = descriptorMap;
    }

    public Descriptors.FileDescriptor getDescriptor() throws GrpcClientException {
        if (this.fileDescriptor != null) {
            return this.fileDescriptor;
        }
        try {
            this.fileDescriptor = this.getFileDescriptor(this.rootDescriptor, this.descriptorMap);
            return this.fileDescriptor;
        }
        catch (Descriptors.DescriptorValidationException | IOException e) {
            throw new GrpcClientException("Error while generating service descriptor : ", e);
        }
    }

    private Descriptors.FileDescriptor getFileDescriptor(String rootDescriptor, MapValue<BString, Object> descriptorMap) throws InvalidProtocolBufferException, Descriptors.DescriptorValidationException, GrpcClientException {
        byte[] descriptor = ServicesBuilderUtils.hexStringToByteArray(rootDescriptor);
        if (descriptor.length == 0) {
            throw new GrpcClientException("Error while reading the service proto descriptor. input descriptor string is null.");
        }
        DescriptorProtos.FileDescriptorProto descriptorProto = DescriptorProtos.FileDescriptorProto.parseFrom((byte[])descriptor);
        if (descriptorProto == null) {
            throw new GrpcClientException("Error while reading the service proto descriptor. File proto descriptor is null.");
        }
        Descriptors.FileDescriptor[] fileDescriptors = new Descriptors.FileDescriptor[descriptorProto.getDependencyList().size()];
        int i = 0;
        for (ByteString dependency : descriptorProto.getDependencyList().asByteStringList()) {
            if (!descriptorMap.containsKey((Object)StringUtils.fromString((String)dependency.toStringUtf8()))) continue;
            BString bRootDescriptor = (BString)descriptorMap.get((Object)StringUtils.fromString((String)dependency.toString(StandardCharsets.UTF_8)));
            fileDescriptors[i++] = this.getFileDescriptor(bRootDescriptor.getValue(), descriptorMap);
        }
        if (fileDescriptors.length > 0 && i == 0) {
            throw new GrpcClientException("Error while reading the service proto descriptor. Couldn't find any dependent descriptors.");
        }
        return Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)descriptorProto, (Descriptors.FileDescriptor[])fileDescriptors);
    }

    private Descriptors.ServiceDescriptor getServiceDescriptor(String clientTypeName) throws GrpcClientException {
        Descriptors.FileDescriptor descriptor = this.getDescriptor();
        if (descriptor.getFile().getServices().isEmpty()) {
            throw new GrpcClientException("No service found in proto definition file");
        }
        Descriptors.ServiceDescriptor serviceDescriptor = null;
        String serviceName = null;
        if (clientTypeName != null) {
            if (clientTypeName.endsWith("BlockingClient")) {
                serviceName = clientTypeName.substring(0, clientTypeName.length() - 14);
            } else if (clientTypeName.endsWith("Client")) {
                serviceName = clientTypeName.substring(0, clientTypeName.length() - 6);
            }
        }
        if (serviceName != null) {
            serviceDescriptor = descriptor.findServiceByName(serviceName);
        }
        if (serviceDescriptor == null) {
            if (descriptor.getFile().getServices().size() == 1) {
                serviceDescriptor = (Descriptors.ServiceDescriptor)descriptor.getFile().getServices().get(0);
            } else {
                throw new GrpcClientException("Couldn't find service descriptor for client endpoint in the proto definition. Please check client endpoint type name with the service name in the proto definition.");
            }
        }
        return serviceDescriptor;
    }

    public Map<String, MethodDescriptor> getMethodDescriptors(BObjectType clientEndpointType) throws GrpcClientException {
        AttachedFunction[] attachedFunctions;
        HashMap<String, MethodDescriptor> descriptorMap = new HashMap<String, MethodDescriptor>();
        Descriptors.ServiceDescriptor serviceDescriptor = this.getServiceDescriptor(clientEndpointType.getName());
        for (AttachedFunction attachedFunction : attachedFunctions = clientEndpointType.getAttachedFunctions()) {
            String methodName = attachedFunction.getName();
            Descriptors.MethodDescriptor methodDescriptor = serviceDescriptor.findMethodByName(methodName);
            if (methodDescriptor == null) {
                throw new GrpcClientException("Error while initializing client stub. Couldn't find method descriptor for remote function: " + methodName);
            }
            Descriptors.Descriptor reqMessage = methodDescriptor.getInputType();
            Descriptors.Descriptor resMessage = methodDescriptor.getOutputType();
            MessageRegistry messageRegistry = MessageRegistry.getInstance();
            messageRegistry.addMessageDescriptor(reqMessage.getName(), reqMessage);
            MessageUtils.setNestedMessages(reqMessage, messageRegistry);
            messageRegistry.addMessageDescriptor(resMessage.getName(), resMessage);
            MessageUtils.setNestedMessages(resMessage, messageRegistry);
            String fullMethodName = MethodDescriptor.generateFullMethodName(serviceDescriptor.getFullName(), methodName);
            BType requestType = this.getInputParameterType(attachedFunction);
            BType responseType = this.getReturnParameterType(attachedFunction);
            MethodDescriptor descriptor = MethodDescriptor.newBuilder().setType(MessageUtils.getMethodType(methodDescriptor.toProto())).setFullMethodName(fullMethodName).setRequestMarshaller(ProtoUtils.marshaller(new MessageParser(reqMessage.getName(), requestType))).setResponseMarshaller(ProtoUtils.marshaller(new MessageParser(resMessage.getName(), responseType == null ? ServicesBuilderUtils.getBallerinaValueType(clientEndpointType.getPackage(), resMessage.getName()) : responseType))).setSchemaDescriptor(methodDescriptor).build();
            descriptorMap.put(fullMethodName, descriptor);
        }
        return Collections.unmodifiableMap(descriptorMap);
    }

    private BType getReturnParameterType(AttachedFunction attachedFunction) {
        BType functionReturnType = attachedFunction.type.getReturnParameterType();
        if (functionReturnType.getTag() == 21) {
            BUnionType unionReturnType = (BUnionType)functionReturnType;
            BType firstParamType = (BType)unionReturnType.getMemberTypes().get(0);
            if (firstParamType.getTag() == 32) {
                BTupleType tupleType = (BTupleType)firstParamType;
                return (BType)tupleType.getTupleTypes().get(0);
            }
            if ("Headers".equals(firstParamType.getName()) && firstParamType.getPackage() != null && "grpc".equals(firstParamType.getPackage().getName())) {
                return BTypes.typeNull;
            }
        }
        return null;
    }

    private BType getInputParameterType(AttachedFunction attachedFunction) {
        BType[] inputParams = attachedFunction.type.getParameterType();
        if (inputParams.length > 0) {
            BType inputType = inputParams[0];
            if (inputType != null && "Headers".equals(inputType.getName()) && inputType.getPackage() != null && "grpc".equals(inputType.getPackage().getName())) {
                return BTypes.typeNull;
            }
            return inputParams[0];
        }
        return BTypes.typeNull;
    }
}

