/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.builder.components;

import com.google.api.AnnotationsProto;
import com.google.api.HttpRule;
import com.google.protobuf.DescriptorProtos;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ballerinalang.net.grpc.MessageUtils;
import org.ballerinalang.net.grpc.MethodDescriptor;
import org.ballerinalang.net.grpc.builder.components.Field;
import org.ballerinalang.net.grpc.builder.components.Message;
import org.ballerinalang.net.grpc.builder.components.Param;
import org.ballerinalang.net.grpc.builder.utils.BalGenerationUtils;

public class Method {
    private String methodName;
    private String methodId;
    private String inputType;
    private boolean primitiveInput;
    private String outputType;
    private MethodDescriptor.MethodType methodType;
    private String httpMethod;
    private String httpPath;
    private String httpBody;
    private List<Param> paramSet;

    private Method(String methodName, String methodId, String inputType, boolean primitiveInput, String outputType, MethodDescriptor.MethodType methodType, String httpMethod, String httpPath, String httpBody, List<Param> paramSet) {
        this.methodName = methodName;
        this.methodType = methodType;
        this.methodId = methodId;
        this.inputType = inputType;
        this.primitiveInput = primitiveInput;
        this.outputType = outputType;
        this.httpMethod = httpMethod;
        this.httpPath = httpPath;
        this.httpBody = httpBody;
        this.paramSet = paramSet;
    }

    public static Builder newBuilder(String methodId) {
        return new Builder(methodId);
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getMethodId() {
        return this.methodId;
    }

    public String getInputType() {
        return this.inputType;
    }

    public boolean getPrimitiveInput() {
        return this.primitiveInput;
    }

    public String getOutputType() {
        return this.outputType;
    }

    public MethodDescriptor.MethodType getMethodType() {
        return this.methodType;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String getHttpPath() {
        return this.httpPath;
    }

    public String getHttpBody() {
        return this.httpBody;
    }

    public List<Param> getParamSet() {
        return this.paramSet;
    }

    public boolean containsEmptyType() {
        return this.inputType == null || this.outputType == null;
    }

    public static class Builder {
        String methodId;
        DescriptorProtos.MethodDescriptorProto methodDescriptor;
        Map<String, Message> messageMap;

        private Builder(String methodId) {
            this.methodId = methodId;
        }

        public Builder setMethodDescriptor(DescriptorProtos.MethodDescriptorProto methodDescriptor) {
            this.methodDescriptor = methodDescriptor;
            return this;
        }

        public Builder setMessageMap(Map<String, Message> messageMap) {
            this.messageMap = messageMap;
            return this;
        }

        public Method build() {
            MethodDescriptor.MethodType methodType = MessageUtils.getMethodType(this.methodDescriptor);
            String methodName = this.methodDescriptor.getName();
            String inputType = this.methodDescriptor.getInputType();
            inputType = inputType != null ? BalGenerationUtils.getMappingBalType(inputType) : null;
            boolean primitiveInput = inputType != null && BalGenerationUtils.checkPrimitiveType(inputType);
            String outputType = this.methodDescriptor.getOutputType();
            outputType = outputType != null ? BalGenerationUtils.getMappingBalType(outputType) : null;
            HttpRule httpExtension = (HttpRule)this.methodDescriptor.getOptions().getExtension(AnnotationsProto.http);
            String httpMethod = httpExtension.getPatternCase().name();
            String httpPath = this.resolveHttpPath(httpExtension);
            String httpBody = httpExtension.getBody();
            List<Param> paramSet = this.getParamList(inputType, this.messageMap, httpExtension);
            return new Method(methodName, this.methodId, inputType, primitiveInput, outputType, methodType, httpMethod, httpPath, httpBody, paramSet);
        }

        private String resolveHttpPath(HttpRule httpExtension) {
            int number = httpExtension.getPatternCase().getNumber();
            switch (number) {
                case 2: {
                    return httpExtension.getGet();
                }
                case 3: {
                    return httpExtension.getPut();
                }
                case 4: {
                    return httpExtension.getPost();
                }
                case 5: {
                    return httpExtension.getDelete();
                }
                case 6: {
                    return httpExtension.getPatch();
                }
            }
            return "";
        }

        private List<Param> getParamList(String inputType, Map<String, Message> messageMap, HttpRule httpExtension) {
            String httpMethod = httpExtension.getPatternCase().name();
            if (httpMethod.equals("PATTERN_NOT_SET") || inputType == null) {
                return new ArrayList<Param>();
            }
            String httpBody = httpExtension.getBody();
            String parentName = "new" + inputType;
            List<String> pathParamList = this.getPathParamList(this.resolveHttpPath(httpExtension));
            Message inputMessage = messageMap.get(inputType);
            if (inputMessage == null) {
                String paramSource = "query";
                if (pathParamList.stream().anyMatch(pathParam -> pathParam.equals("value"))) {
                    paramSource = "path";
                } else if (httpBody.equals("value")) {
                    paramSource = "body";
                }
                Param newParam = new Param("value", parentName, inputType, paramSource, false);
                ArrayList<Param> paramList = new ArrayList<Param>();
                paramList.add(newParam);
                return paramList;
            }
            return this.buildParamList(inputMessage, messageMap, parentName, pathParamList, httpBody);
        }

        private List<Param> buildParamList(Message inputMessage, Map<String, Message> messageMap, String parentName, List<String> pathParamList, String httpBody) {
            ArrayList<Param> paramList = new ArrayList<Param>();
            for (Field inputField : inputMessage.getFieldList()) {
                String fieldName = inputField.getFieldName();
                String fieldType = inputField.getFieldType();
                boolean repeatedParam = false;
                if (inputField.getFieldLabel() != null) {
                    repeatedParam = true;
                }
                String paramSource = "query";
                if (pathParamList.stream().anyMatch(pathParam -> pathParam.equals(fieldName))) {
                    paramSource = "path";
                } else if (fieldName.equals(httpBody)) {
                    paramSource = "body";
                } else if (messageMap.containsKey(fieldType)) {
                    Message newMessage = messageMap.get(fieldType);
                    String newParentName = parentName + "." + fieldName;
                    List<Param> messageParamList = this.buildParamList(newMessage, messageMap, newParentName, pathParamList, httpBody);
                    paramList.addAll(messageParamList);
                    paramSource = "message";
                }
                Param newParam = new Param(fieldName, parentName, fieldType, paramSource, repeatedParam);
                paramList.add(newParam);
            }
            return paramList;
        }

        private List<String> getPathParamList(String httpPath) {
            ArrayList<String> pathList = new ArrayList<String>();
            Pattern p = Pattern.compile("(?<=\\{)([^}]+)(?=})");
            Matcher m = p.matcher(httpPath);
            while (m.find()) {
                pathList.add(m.group());
            }
            return pathList;
        }
    }
}

