/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.builder.components;

import java.util.Arrays;

public class Param {
    private String fieldName;
    private String parentName;
    private String fieldType;
    private String paramSource;
    private boolean repeatedParam;
    private String queryAccessName;

    public Param(String fieldName, String parentName, String fieldType, String paramSource, boolean repeatedParam) {
        this.fieldName = fieldName;
        this.parentName = this.getLastParentName(parentName);
        this.fieldType = fieldType;
        this.paramSource = paramSource;
        this.repeatedParam = repeatedParam;
        this.queryAccessName = this.getAccessName(parentName, paramSource);
    }

    private String getLastParentName(String parentName) {
        String[] parentNames = parentName.split("\\.");
        return parentNames[parentNames.length - 1];
    }

    private String getAccessName(String parentName, String paramSource) {
        String[] parentNames;
        if (paramSource.equals("query") && (parentNames = parentName.split("\\.")).length > 1) {
            CharSequence[] bodyAccessNames = Arrays.copyOfRange(parentNames, 1, parentNames.length);
            return String.join((CharSequence)".", bodyAccessNames) + ".";
        }
        return "";
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public String getParamSource() {
        return this.paramSource;
    }

    public String getParentName() {
        return this.parentName;
    }

    public boolean getRepeatedParam() {
        return this.repeatedParam;
    }

    public String getQueryAccessName() {
        return this.queryAccessName;
    }
}

