/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.builder.components;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ballerinalang.net.grpc.ServerConnectorPortBindingListener;
import org.ballerinalang.net.grpc.builder.components.AbstractStub;
import org.ballerinalang.net.grpc.builder.components.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceFile
extends AbstractStub {
    private boolean enableEp = true;
    private String serviceName;
    private List<Method> unaryFunctions = new ArrayList<Method>();
    private List<Method> streamingFunctions = new ArrayList<Method>();

    private ServiceFile(String serviceName) {
        this.serviceName = serviceName;
    }

    public static Builder newBuilder(String serviceName) {
        return new Builder(serviceName);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public List<Method> getUnaryFunctions() {
        return Collections.unmodifiableList(this.unaryFunctions);
    }

    public List<Method> getStreamingFunctions() {
        return Collections.unmodifiableList(this.streamingFunctions);
    }

    public void setEnableEp(boolean enableEp) {
        this.enableEp = enableEp;
    }

    public boolean isEnableEp() {
        return this.enableEp;
    }

    public static class Builder {
        String serviceName;
        List<Method> methodList = new ArrayList<Method>();
        private static final Logger log = LoggerFactory.getLogger(ServerConnectorPortBindingListener.class);
        private static final PrintStream console = System.err;

        private Builder(String serviceName) {
            this.serviceName = serviceName;
        }

        public Builder addMethod(Method method) {
            this.methodList.add(method);
            return this;
        }

        public ServiceFile build() {
            ServiceFile serviceFile = new ServiceFile(this.serviceName);
            block4: for (Method method : this.methodList) {
                switch (method.getMethodType()) {
                    case UNARY: 
                    case SERVER_STREAMING: {
                        serviceFile.unaryFunctions.add(method);
                        continue block4;
                    }
                    case CLIENT_STREAMING: 
                    case BIDI_STREAMING: {
                        serviceFile.streamingFunctions.add(method);
                        continue block4;
                    }
                }
                String message = this.serviceName + "/" + method.getMethodName() + " is not implemented. Method type is unknown or not supported.";
                log.error(message);
                console.println(message);
            }
            return serviceFile;
        }
    }
}

