/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.builder.utils;

import java.util.Locale;

public class BalGenerationUtils {
    public static String bytesToHex(byte[] data) {
        char[] hexChars = new char[data.length * 2];
        for (int j = 0; j < data.length; ++j) {
            int v = data[j] & 0xFF;
            hexChars[j * 2] = "0123456789ABCDEF".toCharArray()[v >>> 4];
            hexChars[j * 2 + 1] = "0123456789ABCDEF".toCharArray()[v & 0xF];
        }
        return new String(hexChars);
    }

    public static String getMappingBalType(String protoType) {
        switch (protoType) {
            case ".google.protobuf.DoubleValue": 
            case ".google.protobuf.FloatValue": {
                return "float";
            }
            case ".google.protobuf.Int32Value": 
            case ".google.protobuf.Int64Value": 
            case ".google.protobuf.UInt64Value": 
            case ".google.protobuf.UInt32Value": {
                return "int";
            }
            case ".google.protobuf.BoolValue": {
                return "boolean";
            }
            case ".google.protobuf.StringValue": {
                return "string";
            }
            case ".google.protobuf.BytesValue": {
                return "byte[]";
            }
            case ".google.protobuf.Any": {
                return "anydata";
            }
            case ".google.protobuf.Empty": {
                return null;
            }
        }
        return protoType.substring(protoType.lastIndexOf(".") + 1);
    }

    public static String toCamelCase(String name) {
        if (name == null) {
            return null;
        }
        String[] parts = name.split("_");
        StringBuilder camelCaseString = new StringBuilder();
        for (String part : parts) {
            camelCaseString.append(part.substring(0, 1).toUpperCase(Locale.ENGLISH)).append(part.substring(1).toLowerCase(Locale.ENGLISH));
        }
        return camelCaseString.toString();
    }

    public static boolean checkPrimitiveType(String inputType) {
        switch (inputType) {
            case "string": 
            case "int": 
            case "float": 
            case "boolean": 
            case "byte[]": {
                return true;
            }
        }
        return false;
    }
}

