/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.callback;

import io.netty.handler.codec.http.HttpResponseStatus;
import org.ballerinalang.jvm.observability.ObserverContext;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.net.grpc.Message;
import org.ballerinalang.net.grpc.StreamObserver;
import org.ballerinalang.net.grpc.callback.AbstractCallableUnitCallBack;
import org.ballerinalang.net.grpc.listener.ServerCallHandler;

public class UnaryCallableUnitCallBack
extends AbstractCallableUnitCallBack {
    private StreamObserver requestSender;
    private boolean emptyResponse;
    private ObserverContext observerContext;

    public UnaryCallableUnitCallBack(StreamObserver requestSender, boolean isEmptyResponse, ObserverContext context) {
        this.requestSender = requestSender;
        this.emptyResponse = isEmptyResponse;
        this.observerContext = context;
    }

    @Override
    public void notifySuccess() {
        super.notifySuccess();
        if (this.requestSender instanceof ServerCallHandler.ServerCallStreamObserver) {
            ServerCallHandler.ServerCallStreamObserver serverCallStreamObserver = (ServerCallHandler.ServerCallStreamObserver)this.requestSender;
            if (!serverCallStreamObserver.isReady()) {
                return;
            }
            if (serverCallStreamObserver.isCancelled()) {
                return;
            }
        }
        if (this.emptyResponse) {
            this.requestSender.onNext(new Message("Empty", null));
        }
        if (this.observerContext != null) {
            this.observerContext.addProperty("http.status_code", (Object)HttpResponseStatus.OK.code());
        }
        this.requestSender.onCompleted();
    }

    @Override
    public void notifyFailure(ErrorValue error) {
        UnaryCallableUnitCallBack.handleFailure(this.requestSender, error);
        if (this.observerContext != null) {
            this.observerContext.addProperty("http.status_code", (Object)HttpResponseStatus.INTERNAL_SERVER_ERROR.code());
        }
        super.notifyFailure(error);
    }
}

