/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.nativeimpl.caller;

import com.google.protobuf.Descriptors;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.Optional;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.observability.ObserveUtils;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.api.BString;
import org.ballerinalang.net.grpc.Message;
import org.ballerinalang.net.grpc.MessageUtils;
import org.ballerinalang.net.grpc.Status;
import org.ballerinalang.net.grpc.StreamObserver;
import org.ballerinalang.net.grpc.exception.StatusRuntimeException;
import org.ballerinalang.net.grpc.listener.ServerCallHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(FunctionUtils.class);

    public static Object externComplete(ObjectValue endpointClient) {
        StreamObserver responseObserver = MessageUtils.getResponseObserver(endpointClient);
        Descriptors.Descriptor outputType = (Descriptors.Descriptor)endpointClient.getNativeData("RESPONSE_DEFINITION");
        Optional observerContext = ObserveUtils.getObserverContextOfCurrentFrame((Strand)Scheduler.getStrand());
        if (responseObserver == null) {
            return MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("Error while initializing connector. response sender does not exist")));
        }
        try {
            if (!MessageUtils.isEmptyResponse(outputType)) {
                responseObserver.onCompleted();
            }
            observerContext.ifPresent(ctx -> ctx.addProperty("http.status_code", (Object)HttpResponseStatus.OK.code()));
        }
        catch (Exception e) {
            LOG.error("Error while sending complete message to caller.", (Throwable)e);
            return MessageUtils.getConnectorError(e);
        }
        return null;
    }

    public static boolean externIsCancelled(ObjectValue endpointClient) {
        StreamObserver responseObserver = MessageUtils.getResponseObserver(endpointClient);
        if (responseObserver instanceof ServerCallHandler.ServerCallStreamObserver) {
            ServerCallHandler.ServerCallStreamObserver serverCallStreamObserver = (ServerCallHandler.ServerCallStreamObserver)responseObserver;
            return serverCallStreamObserver.isCancelled();
        }
        return Boolean.FALSE;
    }

    public static Object externSend(ObjectValue endpointClient, Object responseValue, Object headerValues) {
        StreamObserver responseObserver = MessageUtils.getResponseObserver(endpointClient);
        Descriptors.Descriptor outputType = (Descriptors.Descriptor)endpointClient.getNativeData("RESPONSE_DEFINITION");
        Optional observerContext = ObserveUtils.getObserverContextOfCurrentFrame((Strand)Scheduler.getStrand());
        if (responseObserver == null) {
            return MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("Error while initializing connector. Response sender does not exist")));
        }
        try {
            if (!MessageUtils.isEmptyResponse(outputType)) {
                Message responseMessage = new Message(outputType.getName(), responseValue);
                HttpHeaders headers = null;
                if (headerValues != null && TypeChecker.getType((Object)headerValues).getTag() == 35) {
                    headers = (HttpHeaders)((ObjectValue)headerValues).getNativeData("MessageHeaders");
                }
                if (headers != null) {
                    responseMessage.setHeaders(headers);
                    headers.entries().forEach(x -> observerContext.ifPresent(ctx -> ctx.addTag((String)x.getKey(), (String)x.getValue())));
                }
                responseObserver.onNext(responseMessage);
            }
        }
        catch (Exception e) {
            LOG.error("Error while sending client response.", (Throwable)e);
            return MessageUtils.getConnectorError(e);
        }
        return null;
    }

    public static Object externSendError(ObjectValue endpointClient, long statusCode, BString errorMsg, Object headerValues) {
        StreamObserver responseObserver = MessageUtils.getResponseObserver(endpointClient);
        Optional observerContext = ObserveUtils.getObserverContextOfCurrentFrame((Strand)Scheduler.getStrand());
        if (responseObserver == null) {
            return MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("Error while sending the error. Response observer not found.")));
        }
        try {
            HttpHeaders headers = null;
            Message errorMessage = new Message(new StatusRuntimeException(Status.fromCodeValue((int)statusCode).withDescription(errorMsg.getValue())));
            if (headerValues != null && TypeChecker.getType((Object)headerValues).getTag() == 35) {
                headers = (HttpHeaders)((ObjectValue)headerValues).getNativeData("MessageHeaders");
            }
            if (headers != null) {
                errorMessage.setHeaders(headers);
                headers.entries().forEach(x -> observerContext.ifPresent(ctx -> ctx.addTag((String)x.getKey(), (String)x.getValue())));
            }
            int mappedStatusCode = MessageUtils.getMappingHttpStatusCode((int)statusCode);
            observerContext.ifPresent(ctx -> ctx.addProperty("http.status_code", (Object)mappedStatusCode));
            responseObserver.onError(errorMessage);
        }
        catch (Exception e) {
            LOG.error("Error while sending error to caller.", (Throwable)e);
            return MessageUtils.getConnectorError(e);
        }
        return null;
    }
}

