/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.nativeimpl.streamingclient;

import com.google.protobuf.Descriptors;
import java.util.Optional;
import org.ballerinalang.jvm.observability.ObserveUtils;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.api.BString;
import org.ballerinalang.net.grpc.Message;
import org.ballerinalang.net.grpc.MessageUtils;
import org.ballerinalang.net.grpc.Status;
import org.ballerinalang.net.grpc.StreamObserver;
import org.ballerinalang.net.grpc.exception.StatusRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(FunctionUtils.class);

    public static Object streamSend(ObjectValue streamConnection, Object responseValue) {
        StreamObserver requestSender = (StreamObserver)streamConnection.getNativeData("REQUEST_SENDER");
        if (requestSender == null) {
            return MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("Error while sending the message. endpoint does not exist")));
        }
        Descriptors.Descriptor inputType = (Descriptors.Descriptor)streamConnection.getNativeData("REQUEST_DEFINITION");
        try {
            Message requestMessage = new Message(inputType.getName(), responseValue);
            requestSender.onNext(requestMessage);
        }
        catch (Exception e) {
            LOG.error("Error while sending request message to server.", (Throwable)e);
            return MessageUtils.getConnectorError(e);
        }
        return null;
    }

    public static Object streamSendError(ObjectValue streamingConnection, long statusCode, BString errorMsg) {
        StreamObserver requestSender = (StreamObserver)streamingConnection.getNativeData("REQUEST_SENDER");
        if (requestSender == null) {
            return MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("Error while sending the error. endpoint does not exist")));
        }
        try {
            requestSender.onError(new Message(new StatusRuntimeException(Status.fromCodeValue((int)statusCode).withDescription(errorMsg.getValue()))));
            Optional observerContext = ObserveUtils.getObserverContextOfCurrentFrame((Strand)Scheduler.getStrand());
            observerContext.ifPresent(ctx -> ctx.addTag("grpc.error_message", MessageUtils.getMappingHttpStatusCode((int)statusCode) + " : " + errorMsg.getValue()));
        }
        catch (Exception e) {
            LOG.error("Error while sending error to server.", (Throwable)e);
            return MessageUtils.getConnectorError(e);
        }
        return null;
    }

    public static Object streamComplete(ObjectValue streamingConnection) {
        StreamObserver requestSender = (StreamObserver)streamingConnection.getNativeData("REQUEST_SENDER");
        if (requestSender == null) {
            return MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("Error while completing the message. endpoint does not exist")));
        }
        try {
            requestSender.onCompleted();
        }
        catch (Exception e) {
            LOG.error("Error while sending complete message to server.", (Throwable)e);
            return MessageUtils.getConnectorError(e);
        }
        return null;
    }
}

