/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.proto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.ServiceNode;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.ballerinalang.util.diagnostic.Diagnostic;
import org.ballerinalang.util.diagnostic.DiagnosticLog;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public class ServiceDefinitionValidator {
    public static final int COMPULSORY_PARAM_COUNT = 1;

    public static boolean validate(ServiceNode serviceNode, DiagnosticLog dlog) {
        return ServiceDefinitionValidator.validateAnnotation(serviceNode, dlog) && ServiceDefinitionValidator.validateResource(serviceNode, dlog);
    }

    private static boolean validateAnnotation(ServiceNode serviceNode, DiagnosticLog dlog) {
        List annotations = serviceNode.getAnnotationAttachments();
        ArrayList<BLangRecordLiteral.BLangRecordKeyValueField> annVals = new ArrayList<BLangRecordLiteral.BLangRecordKeyValueField>();
        int count = 0;
        Iterator iterator = annotations.iterator();
        while (iterator.hasNext()) {
            AnnotationAttachmentNode annotation = (AnnotationAttachmentNode)iterator.next();
            if (!annotation.getAnnotationName().getValue().equals("ServiceConfig") || annotation.getExpression() == null) continue;
            for (RecordLiteralNode.RecordField field : ((BLangRecordLiteral)annotation.getExpression()).fields) {
                annVals.add((BLangRecordLiteral.BLangRecordKeyValueField)field);
            }
            ++count;
        }
        if (count > 1) {
            dlog.logDiagnostic(Diagnostic.Kind.ERROR, serviceNode.getPosition(), (CharSequence)"There cannot be more than one service annotations");
            return false;
        }
        if (count == 1 && (iterator = annVals.iterator()).hasNext()) {
            BLangRecordLiteral.BLangRecordKeyValueField keyValue = (BLangRecordLiteral.BLangRecordKeyValueField)iterator.next();
            return ((BLangSimpleVarRef)keyValue.key.expr).variableName.getValue().equals("name");
        }
        return true;
    }

    private static boolean validateResource(ServiceNode serviceNode, DiagnosticLog dlog) {
        List resources = serviceNode.getResources();
        for (BLangFunction resourceNode : resources) {
            if (ServiceDefinitionValidator.validateResourceSignature(resourceNode, dlog, resourceNode.pos)) continue;
            return false;
        }
        return true;
    }

    private static boolean validateResourceSignature(BLangFunction resourceNode, DiagnosticLog dlog, DiagnosticPos pos) {
        List signatureParams = resourceNode.getParameters();
        int nParams = signatureParams.size();
        if (nParams < 1) {
            dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)pos, (CharSequence)"resource signature parameter count should be >= 1");
            return false;
        }
        if (!ServiceDefinitionValidator.isValidResourceParam((BLangSimpleVariable)signatureParams.get(0), "ballerina/grpc:0.7.0:Caller")) {
            dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)pos, (CharSequence)"first parameter should be of type ballerina/grpc:0.7.0:Caller");
            return false;
        }
        return true;
    }

    private static boolean isValidResourceParam(BLangSimpleVariable param, String expectedType) {
        return expectedType.equals(param.type.toString());
    }
}

