/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.proto;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.compiler.plugins.AbstractCompilerPlugin;
import org.ballerinalang.compiler.plugins.SupportedResourceParamTypes;
import org.ballerinalang.model.TreeBuilder;
import org.ballerinalang.model.elements.AttachPoint;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.ServiceNode;
import org.ballerinalang.model.tree.expressions.LiteralNode;
import org.ballerinalang.net.grpc.proto.ServiceDefinitionValidator;
import org.ballerinalang.util.diagnostic.Diagnostic;
import org.ballerinalang.util.diagnostic.DiagnosticLog;
import org.wso2.ballerinalang.compiler.desugar.ASTBuilderUtil;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolResolver;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAnnotationSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BStructureTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstant;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

@SupportedResourceParamTypes(expectedListenerType=@SupportedResourceParamTypes.Type(packageName="grpc", name="Listener"), paramTypes={@SupportedResourceParamTypes.Type(packageName="grpc", name="Caller")})
public class ServiceProtoBuilder
extends AbstractCompilerPlugin {
    private DiagnosticLog dlog;
    private static final PrintStream error = System.err;
    private SymbolResolver symResolver = null;
    private SymbolTable symTable = null;
    private Names names = null;

    public void setCompilerContext(CompilerContext context) {
        super.setCompilerContext(context);
        this.symResolver = SymbolResolver.getInstance((CompilerContext)context);
        this.symTable = SymbolTable.getInstance((CompilerContext)context);
        this.names = Names.getInstance((CompilerContext)context);
    }

    public void init(DiagnosticLog diagnosticLog) {
        this.dlog = diagnosticLog;
    }

    public void process(ServiceNode service, List<AnnotationAttachmentNode> annotations) {
        BLangService serviceNode = (BLangService)service;
        if (ServiceDefinitionValidator.validate((ServiceNode)serviceNode, this.dlog)) {
            Optional<Object> rootDescriptor = Optional.empty();
            Optional<Object> descriptorMapFunc = Optional.empty();
            BLangNode serviceParentNode = serviceNode.parent;
            if (serviceParentNode instanceof BLangPackage) {
                BLangPackage packageNode = (BLangPackage)serviceParentNode;
                rootDescriptor = ((ArrayList)packageNode.constants).stream().filter(var -> "ROOT_DESCRIPTOR".equals(((BLangConstant)var).getName().getValue())).findFirst();
                descriptorMapFunc = ((ArrayList)packageNode.functions).stream().filter(var -> "getDescriptorMap".equals(((BLangFunction)var).getName().getValue())).findFirst();
            }
            for (AnnotationAttachmentNode annonNodes : serviceNode.getAnnotationAttachments()) {
                if (!"ServiceDescriptor".equals(annonNodes.getAnnotationName().getValue())) continue;
                return;
            }
            if (rootDescriptor.isPresent() && descriptorMapFunc.isPresent()) {
                this.addDescriptorAnnotation((ServiceNode)serviceNode, (String)((BLangLiteral)((BLangConstant)rootDescriptor.get()).expr).getValue());
            } else {
                this.dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)serviceNode.getPosition(), (CharSequence)"Root descriptor and/or the descriptor map function is missing");
            }
        }
    }

    private void addDescriptorAnnotation(ServiceNode serviceNode, String rootDescriptor) {
        BSymbol mapVarSymbol;
        BLangService service = (BLangService)serviceNode;
        DiagnosticPos pos = service.pos;
        BLangAnnotationAttachment annoAttachment = (BLangAnnotationAttachment)TreeBuilder.createAnnotAttachmentNode();
        serviceNode.addAnnotationAttachment((AnnotationAttachmentNode)annoAttachment);
        SymbolEnv pkgEnv = (SymbolEnv)this.symTable.pkgEnvMap.get(service.symbol.getEnclosingSymbol());
        BSymbol annSymbol = this.symResolver.lookupAnnotationSpaceSymbolInPackage(service.pos, pkgEnv, this.names.fromString("grpc"), this.names.fromString("ServiceDescriptor"));
        if (annSymbol instanceof BAnnotationSymbol) {
            annoAttachment.annotationSymbol = (BAnnotationSymbol)annSymbol;
        }
        annoAttachment.annotationName = (BLangIdentifier)TreeBuilder.createIdentifierNode();
        annoAttachment.annotationName.value = "ServiceDescriptor";
        annoAttachment.annotationName.pos = pos;
        annoAttachment.pos = pos;
        BLangRecordLiteral literalNode = (BLangRecordLiteral)TreeBuilder.createRecordLiteralNode();
        annoAttachment.expr = literalNode;
        BLangIdentifier pkgAlias = (BLangIdentifier)TreeBuilder.createIdentifierNode();
        pkgAlias.setValue("grpc");
        pkgAlias.pos = pos;
        annoAttachment.pkgAlias = pkgAlias;
        annoAttachment.attachPoints.add(AttachPoint.Point.SERVICE);
        literalNode.pos = pos;
        BStructureTypeSymbol bStructSymbol = null;
        BSymbol annTypeSymbol = this.symResolver.lookupMainSpaceSymbolInPackage(service.pos, pkgEnv, this.names.fromString("grpc"), this.names.fromString("ServiceDescriptorData"));
        if (annTypeSymbol instanceof BStructureTypeSymbol) {
            bStructSymbol = (BStructureTypeSymbol)annTypeSymbol;
            literalNode.type = bStructSymbol.type;
        }
        BLangRecordLiteral.BLangRecordKeyValueField descriptorKeyValue = (BLangRecordLiteral.BLangRecordKeyValueField)TreeBuilder.createRecordKeyValue();
        literalNode.fields.add(descriptorKeyValue);
        BLangLiteral keyLiteral = (BLangLiteral)TreeBuilder.createLiteralExpression();
        keyLiteral.value = "descriptor";
        keyLiteral.type = this.symTable.stringType;
        BLangLiteral valueLiteral = null;
        LiteralNode literalExpression = TreeBuilder.createLiteralExpression();
        NodeKind nodeKind = literalExpression.getKind();
        if (nodeKind == NodeKind.LITERAL || nodeKind == NodeKind.NUMERIC_LITERAL) {
            valueLiteral = (BLangLiteral)literalExpression;
            if (rootDescriptor != null) {
                valueLiteral.value = rootDescriptor;
            }
            valueLiteral.type = this.symTable.stringType;
        }
        descriptorKeyValue.key = new BLangRecordLiteral.BLangRecordKey((BLangExpression)keyLiteral);
        BSymbol fieldSymbol = this.symResolver.resolveStructField(service.pos, pkgEnv, this.names.fromString("descriptor"), (BTypeSymbol)bStructSymbol);
        if (fieldSymbol instanceof BVarSymbol) {
            descriptorKeyValue.key.fieldSymbol = (BVarSymbol)fieldSymbol;
        }
        if (valueLiteral != null) {
            descriptorKeyValue.valueExpr = valueLiteral;
        }
        if ((mapVarSymbol = this.symResolver.lookupSymbolInMainSpace(pkgEnv, this.names.fromString("getDescriptorMap"))) == null || mapVarSymbol.type.tag == 23) {
            return;
        }
        BLangInvocation functionRef = null;
        if (mapVarSymbol instanceof BInvokableSymbol) {
            functionRef = ASTBuilderUtil.createInvocationExpr((DiagnosticPos)pos, (BInvokableSymbol)((BInvokableSymbol)mapVarSymbol), new ArrayList(), (SymbolResolver)this.symResolver);
            functionRef.symbol = mapVarSymbol;
            functionRef.type = this.symTable.mapType;
            BLangIdentifier funcName = (BLangIdentifier)TreeBuilder.createIdentifierNode();
            funcName.setValue("getDescriptorMap");
            funcName.pos = pos;
            functionRef.name = funcName;
            BLangIdentifier funcPkgAlias = (BLangIdentifier)TreeBuilder.createIdentifierNode();
            funcPkgAlias.setValue("");
            funcPkgAlias.pos = pos;
            functionRef.pkgAlias = funcPkgAlias;
        }
        BLangRecordLiteral.BLangRecordKeyValueField mapKeyValue = (BLangRecordLiteral.BLangRecordKeyValueField)TreeBuilder.createRecordKeyValue();
        literalNode.fields.add(mapKeyValue);
        BLangSimpleVarRef mapKeyLiteral = (BLangSimpleVarRef)TreeBuilder.createSimpleVariableReferenceNode();
        BLangIdentifier keyName = (BLangIdentifier)TreeBuilder.createIdentifierNode();
        keyName.setValue("descMap");
        keyName.pos = pos;
        mapKeyLiteral.variableName = keyName;
        mapKeyLiteral.type = this.symTable.mapType;
        mapKeyLiteral.pos = pos;
        mapKeyValue.key = new BLangRecordLiteral.BLangRecordKey((BLangExpression)mapKeyLiteral);
        mapKeyValue.valueExpr = functionRef;
        mapKeyValue.pos = pos;
    }
}

