/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.java;

import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.util.exceptions.BallerinaErrorReasons;
import org.ballerinalang.jvm.values.HandleValue;
import org.ballerinalang.jvm.values.api.BString;
import org.ballerinalang.natives.annotations.BallerinaFunction;

@BallerinaFunction(orgName="ballerina", packageName="java", version="0.9.0", functionName="getClass")
public class JavaUtils {
    private static final String booleanTypeName = "boolean";
    private static final String byteTypeName = "byte";
    private static final String shortTypeName = "short";
    private static final String charTypeName = "char";
    private static final String intTypeName = "int";
    private static final String longTypeName = "long";
    private static final String floatTypeName = "float";
    private static final String doubleTypeName = "double";
    private static final BPackage JAVA_PACKAGE_ID = new BPackage("ballerina", "java", "0.9.0");

    public static Object getClass(Strand strand, BString namebStr) {
        String name = namebStr.getValue();
        Class<?> clazz = JavaUtils.getPrimitiveTypeClass(name);
        if (clazz != null) {
            return new HandleValue(clazz);
        }
        try {
            clazz = Class.forName(name);
            return new HandleValue(clazz);
        }
        catch (ClassNotFoundException e) {
            return BallerinaErrors.createDistinctError((String)BallerinaErrorReasons.JAVA_CLASS_NOT_FOUND_ERROR, (BPackage)JAVA_PACKAGE_ID, (String)name);
        }
    }

    private static Class<?> getPrimitiveTypeClass(String name) {
        switch (name) {
            case "boolean": {
                return Boolean.TYPE;
            }
            case "byte": {
                return Byte.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
        }
        return null;
    }
}

