/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.jms.nativeimpl.message;

import javax.jms.JMSException;
import javax.jms.Message;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.CallableUnitCallback;
import org.ballerinalang.connector.api.Struct;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BBoolean;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.net.jms.AbstractBlockinAction;
import org.ballerinalang.net.jms.utils.BallerinaAdapter;

@BallerinaFunction(orgName="ballerina", packageName="jms", functionName="getRedelivered", receiver=@Receiver(type=TypeKind.STRUCT, structType="Message", structPackage="ballerina.jms"), returnType={@ReturnType(type=TypeKind.BOOLEAN)}, isPublic=true)
public class GetRedelivered
extends AbstractBlockinAction {
    public void execute(Context context, CallableUnitCallback callableUnitCallback) {
        Struct messageStruct = BallerinaAdapter.getReceiverObject(context);
        Message message = BallerinaAdapter.getNativeObject(messageStruct, "jms_message_object", Message.class, context);
        try {
            boolean redelivered = message.getJMSRedelivered();
            context.setReturnValues(new BValue[]{new BBoolean(redelivered)});
        }
        catch (JMSException e) {
            BallerinaAdapter.returnError("Error when retrieving redelivery flag", context, e);
        }
    }
}

