/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.jms.nativeimpl.endpoint.common;

import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import org.ballerinalang.bre.Context;
import org.ballerinalang.connector.api.BLangConnectorSPIUtil;
import org.ballerinalang.connector.api.Resource;
import org.ballerinalang.connector.api.Service;
import org.ballerinalang.connector.api.Struct;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.net.jms.JMSUtils;
import org.ballerinalang.net.jms.JmsMessageListenerImpl;
import org.ballerinalang.net.jms.utils.BallerinaAdapter;

public class MessageListenerHandler {
    private MessageListenerHandler() {
    }

    public static void createAndRegister(Context context) {
        Struct queueConsumerBObject = BallerinaAdapter.getReceiverObject(context);
        Service service = BLangConnectorSPIUtil.getServiceRegistered((Context)context);
        BStruct consumerConnector = (BStruct)context.getRefArgument(2);
        Resource resource = JMSUtils.extractJMSResource(service);
        Object nativeData = consumerConnector.getNativeData("jms_consumer_object");
        if (nativeData instanceof MessageConsumer) {
            JmsMessageListenerImpl listener = new JmsMessageListenerImpl(resource, queueConsumerBObject.getVMValue());
            try {
                ((MessageConsumer)nativeData).setMessageListener((MessageListener)listener);
            }
            catch (JMSException e) {
                BallerinaAdapter.throwBallerinaException("Error registering the message listener for service" + service.getPackage() + service.getName(), context, e);
            }
        }
    }
}

