/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.jms.nativeimpl.endpoint.connection;

import javax.jms.Connection;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.CallableUnitCallback;
import org.ballerinalang.connector.api.Struct;
import org.ballerinalang.model.NativeCallableUnit;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.net.jms.JMSUtils;
import org.ballerinalang.net.jms.LoggingExceptionListener;
import org.ballerinalang.net.jms.utils.BallerinaAdapter;

@BallerinaFunction(orgName="ballerina", packageName="jms", functionName="createConnection", receiver=@Receiver(type=TypeKind.STRUCT, structType="Connection", structPackage="ballerina.jms"), args={@Argument(name="config", type=TypeKind.STRUCT, structType="ConnectionConfiguration")}, isPublic=true)
public class CreateConnection
implements NativeCallableUnit {
    public void execute(Context context, CallableUnitCallback callableUnitCallback) {
        Struct connectionBObject = BallerinaAdapter.getReceiverObject(context);
        Struct connectionConfig = connectionBObject.getStructField("config");
        Connection connection = JMSUtils.createConnection(connectionConfig);
        try {
            connection.setExceptionListener((ExceptionListener)new LoggingExceptionListener());
            connection.start();
        }
        catch (JMSException e) {
            BallerinaAdapter.throwBallerinaException("Error occurred while starting connection.", context, e);
        }
        connectionBObject.addNativeData("jms_connection_object", (Object)connection);
    }

    public boolean isBlocking() {
        return true;
    }
}

