/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.jms.nativeimpl.endpoint.topic.durable.subscriber;

import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.CallableUnitCallback;
import org.ballerinalang.connector.api.Struct;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.net.jms.AbstractBlockinAction;
import org.ballerinalang.net.jms.JMSUtils;
import org.ballerinalang.net.jms.nativeimpl.endpoint.common.SessionConnector;
import org.ballerinalang.net.jms.utils.BallerinaAdapter;
import org.ballerinalang.util.exceptions.BallerinaException;

@BallerinaFunction(orgName="ballerina", packageName="jms", functionName="createSubscriber", receiver=@Receiver(type=TypeKind.STRUCT, structType="DurableTopicSubscriber", structPackage="ballerina.jms"), args={@Argument(name="session", type=TypeKind.STRUCT, structType="Session"), @Argument(name="messageSelector", type=TypeKind.STRING)}, isPublic=true)
public class CreateSubscriber
extends AbstractBlockinAction {
    public void execute(Context context, CallableUnitCallback callback) {
        Struct topicSubscriberBObject = BallerinaAdapter.getReceiverObject(context);
        BStruct sessionBObject = (BStruct)context.getRefArgument(1);
        String messageSelector = context.getStringArgument(0);
        Session session = BallerinaAdapter.getNativeObject(sessionBObject, "jms_session_object", Session.class, context);
        Struct topicSubscriberConfigBRecord = topicSubscriberBObject.getStructField("config");
        String topicPattern = topicSubscriberConfigBRecord.getStringField("topicPattern");
        String consumerId = topicSubscriberConfigBRecord.getStringField("identifier");
        if (JMSUtils.isNullOrEmptyAfterTrim(consumerId)) {
            throw new BallerinaException("Please provide a durable subscription ID", context);
        }
        try {
            Topic topic = JMSUtils.getTopic(session, topicPattern);
            TopicSubscriber consumer = session.createDurableSubscriber(topic, consumerId, messageSelector, false);
            Struct consumerConnectorBObject = topicSubscriberBObject.getStructField("connector");
            consumerConnectorBObject.addNativeData("jms_consumer_object", (Object)consumer);
            consumerConnectorBObject.addNativeData("jms_session_connector_object", (Object)new SessionConnector(session));
        }
        catch (JMSException e) {
            BallerinaAdapter.throwBallerinaException("Error while creating queue consumer", context, e);
        }
    }
}

