/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.jms.nativeimpl.endpoint.topic.publisher;

import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.CallableUnitCallback;
import org.ballerinalang.connector.api.Struct;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.net.jms.AbstractBlockinAction;
import org.ballerinalang.net.jms.JMSUtils;
import org.ballerinalang.net.jms.nativeimpl.endpoint.common.SessionConnector;
import org.ballerinalang.net.jms.utils.BallerinaAdapter;
import org.ballerinalang.util.exceptions.BallerinaException;

@BallerinaFunction(orgName="ballerina", packageName="jms", functionName="initTopicPublisher", receiver=@Receiver(type=TypeKind.STRUCT, structType="TopicPublisher", structPackage="ballerina.jms"), args={@Argument(name="session", type=TypeKind.STRUCT, structType="Session")}, isPublic=true)
public class InitTopicPublisher
extends AbstractBlockinAction {
    public void execute(Context context, CallableUnitCallback callback) {
        Struct topicProducerBObject = BallerinaAdapter.getReceiverObject(context);
        Struct topicProducerConfig = topicProducerBObject.getStructField("config");
        String topicPattern = topicProducerConfig.getStringField("topicPattern");
        if (JMSUtils.isNullOrEmptyAfterTrim(topicPattern)) {
            throw new BallerinaException("Topic pattern cannot be null", context);
        }
        BStruct sessionBObject = (BStruct)context.getRefArgument(1);
        Session session = BallerinaAdapter.getNativeObject(sessionBObject, "jms_session_object", Session.class, context);
        try {
            Topic topic = null;
            if (!JMSUtils.isNullOrEmptyAfterTrim(topicPattern)) {
                topic = JMSUtils.getTopic(session, topicPattern);
            }
            MessageProducer producer = session.createProducer(topic);
            Struct topicProducerConnectorBObject = topicProducerBObject.getStructField("connector");
            topicProducerConnectorBObject.addNativeData("jms_producer_object", (Object)producer);
            topicProducerConnectorBObject.addNativeData("jms_session_connector_object", (Object)new SessionConnector(session));
        }
        catch (JMSException e) {
            BallerinaAdapter.throwBallerinaException("Error creating topic producer", context, e);
        }
    }
}

