/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.jms.nativeimpl.message;

import java.util.Objects;
import javax.jms.JMSException;
import javax.jms.Message;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.CallableUnitCallback;
import org.ballerinalang.connector.api.Struct;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.net.jms.AbstractBlockinAction;
import org.ballerinalang.net.jms.utils.BallerinaAdapter;

@BallerinaFunction(orgName="ballerina", packageName="jms", functionName="getStringProperty", receiver=@Receiver(type=TypeKind.STRUCT, structType="Message", structPackage="ballerina.jms"), args={@Argument(name="key", type=TypeKind.STRING)}, returnType={@ReturnType(type=TypeKind.STRING), @ReturnType(type=TypeKind.NIL)}, isPublic=true)
public class GetStringProperty
extends AbstractBlockinAction {
    public void execute(Context context, CallableUnitCallback callableUnitCallback) {
        Struct messageStruct = BallerinaAdapter.getReceiverObject(context);
        Message message = BallerinaAdapter.getNativeObject(messageStruct, "jms_message_object", Message.class, context);
        String key = context.getStringArgument(0);
        try {
            String stringProperty = message.getStringProperty(key);
            if (Objects.isNull(stringProperty)) {
                context.setReturnValues(new BValue[0]);
            } else {
                context.setReturnValues(new BValue[]{new BString(stringProperty)});
            }
        }
        catch (JMSException e) {
            BallerinaAdapter.returnError("Error when retrieving string property", context, e);
        }
    }
}

