/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.jms.nativeimpl.message;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.CallableUnitCallback;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.net.jms.AbstractBlockinAction;
import org.ballerinalang.net.jms.JMSUtils;
import org.ballerinalang.net.jms.utils.BallerinaAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(orgName="ballerina", packageName="jms", functionName="getTextMessageContent", receiver=@Receiver(type=TypeKind.STRUCT, structType="Message", structPackage="ballerina.jms"), returnType={@ReturnType(type=TypeKind.STRING)}, isPublic=true)
public class GetTextMessageContent
extends AbstractBlockinAction {
    private static final Logger log = LoggerFactory.getLogger(GetTextMessageContent.class);

    public void execute(Context context, CallableUnitCallback callableUnitCallback) {
        BStruct messageStruct = (BStruct)context.getRefArgument(0);
        Message jmsMessage = JMSUtils.getJMSMessage(messageStruct);
        String messageContent = null;
        try {
            if (jmsMessage instanceof TextMessage) {
                messageContent = ((TextMessage)jmsMessage).getText();
            } else {
                log.error("JMSMessage is not a Text message. ");
            }
        }
        catch (JMSException e) {
            BallerinaAdapter.returnError("Error when retrieving JMS message content.", context, e);
        }
        if (log.isDebugEnabled()) {
            log.debug("Get content from the JMS message");
        }
        context.setReturnValues(new BValue[]{new BString(messageContent)});
    }
}

