/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.llvm;

import java.util.function.IntFunction;
import org.ballerinalang.bre.Context;
import org.ballerinalang.connector.api.BallerinaConnectorException;
import org.ballerinalang.model.types.BStructureType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.BValueArray;
import org.ballerinalang.util.codegen.PackageInfo;
import org.ballerinalang.util.codegen.StructureTypeInfo;

public class FFIUtil {
    public static final String LLVM_PKG_PATH = "ballerina/llvm";
    public static final String NATIVE_KEY = "native";

    public static BMap<String, BValue> newRecord(Context context, String type) {
        PackageInfo packageInfo = context.getProgramFile().getPackageInfo(LLVM_PKG_PATH);
        if (packageInfo == null) {
            throw new BallerinaConnectorException("package - ballerina/llvm does not exist");
        }
        StructureTypeInfo structureInfo = packageInfo.getStructInfo(type);
        BStructureType structType = structureInfo.getType();
        return new BMap((BType)structType);
    }

    public static <T> T getRecodeArgumentNative(Context context, int index) {
        return FFIUtil.getaNative(context.getRefArgument(index));
    }

    public static <T> T[] getRecodeArrayArgumentNative(Context context, int index, IntFunction<T[]> generator) {
        BValueArray refArray = (BValueArray)context.getRefArgument(index);
        T[] nativeArray = generator.apply((int)refArray.size());
        BRefType[] values = refArray.getValues();
        int i = 0;
        while ((long)i < refArray.size()) {
            BRefType bRefType = values[i];
            nativeArray[i] = FFIUtil.getaNative((BValue)bRefType);
            ++i;
        }
        return nativeArray;
    }

    private static <T> T getaNative(BValue ref) {
        return (T)((BMap)ref).getNativeData(NATIVE_KEY);
    }

    public static void addNativeToRecode(Object module, BMap<String, BValue> bStruct) {
        bStruct.addNativeData(NATIVE_KEY, module);
    }
}

