/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.mime.nativeimpl;

import java.util.Locale;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BlockingNativeCallableUnit;
import org.ballerinalang.mime.util.EntityBodyHandler;
import org.ballerinalang.mime.util.HeaderUtil;
import org.ballerinalang.mime.util.MimeUtil;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BJSON;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.runtime.message.MessageDataSource;

@BallerinaFunction(orgName="ballerina", packageName="mime", functionName="getJson", receiver=@Receiver(type=TypeKind.STRUCT, structType="Entity", structPackage="ballerina.mime"), returnType={@ReturnType(type=TypeKind.JSON), @ReturnType(type=TypeKind.STRUCT)}, isPublic=true)
public class GetJson
extends BlockingNativeCallableUnit {
    public void execute(Context context) {
        try {
            BStruct entityStruct = (BStruct)context.getRefArgument(0);
            String baseType = HeaderUtil.getBaseType(entityStruct);
            if (baseType != null && (baseType.toLowerCase(Locale.getDefault()).endsWith("/json") || baseType.toLowerCase(Locale.getDefault()).endsWith("+json"))) {
                BJSON result;
                MessageDataSource dataSource = EntityBodyHandler.getMessageDataSource(entityStruct);
                if (dataSource != null) {
                    result = dataSource instanceof BJSON ? (BJSON)dataSource : new BJSON(dataSource.getMessageAsString());
                } else {
                    result = EntityBodyHandler.constructJsonDataSource(entityStruct);
                    EntityBodyHandler.addMessageDataSource(entityStruct, (MessageDataSource)result);
                    entityStruct.addNativeData("entity_byte_channel", null);
                }
                context.setReturnValues(new BValue[]{result});
            } else {
                context.setReturnValues(new BValue[]{MimeUtil.createEntityError(context, "Entity body is not json compatible since the received content-type is : " + baseType)});
            }
        }
        catch (Throwable e) {
            context.setReturnValues(new BValue[]{MimeUtil.createEntityError(context, "Error occurred while extracting json data from entity: " + e.getMessage())});
        }
    }
}

