/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.mime.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import org.ballerinalang.bre.Context;
import org.ballerinalang.mime.util.EntityBodyChannel;
import org.ballerinalang.mime.util.EntityWrapper;
import org.ballerinalang.mime.util.MimeEntityWrapper;
import org.ballerinalang.mime.util.MimeUtil;
import org.ballerinalang.mime.util.MultipartDecoder;
import org.ballerinalang.model.types.BStructType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.util.StringUtils;
import org.ballerinalang.model.util.XMLUtils;
import org.ballerinalang.model.values.BJSON;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BRefValueArray;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BXML;
import org.ballerinalang.nativeimpl.io.BallerinaIOException;
import org.ballerinalang.nativeimpl.io.channels.TempFileIOChannel;
import org.ballerinalang.nativeimpl.io.channels.base.Channel;
import org.ballerinalang.runtime.message.BlobDataSource;
import org.ballerinalang.runtime.message.MessageDataSource;
import org.ballerinalang.runtime.message.StringDataSource;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.jvnet.mimepull.MIMEPart;

public class EntityBodyHandler {
    public static void setDiscreteMediaTypeBodyContent(BStruct entityStruct, InputStream inputStream, int numberOfBytesRead) {
        if (numberOfBytesRead < 0x200000) {
            entityStruct.addNativeData("entity_byte_channel", (Object)new EntityWrapper(new EntityBodyChannel(inputStream)));
        } else {
            String temporaryFilePath = MimeUtil.writeToTemporaryFile(inputStream, "BallerinaTempFile");
            entityStruct.addNativeData("entity_byte_channel", (Object)EntityBodyHandler.getByteChannelForTempFile(temporaryFilePath));
        }
    }

    public static EntityWrapper getEntityWrapper(String textPayload) {
        return new EntityWrapper(new EntityBodyChannel(new ByteArrayInputStream(textPayload.getBytes(StandardCharsets.UTF_8))));
    }

    public static TempFileIOChannel getByteChannelForTempFile(String temporaryFilePath) {
        FileChannel fileChannel;
        HashSet<StandardOpenOption> options = new HashSet<StandardOpenOption>();
        options.add(StandardOpenOption.READ);
        Path path = Paths.get(temporaryFilePath, new String[0]);
        try {
            fileChannel = (FileChannel)Files.newByteChannel(path, options, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new BallerinaException("Error occurred while creating a file channel from a temporary file");
        }
        return new TempFileIOChannel(fileChannel, 16384, temporaryFilePath);
    }

    public static MessageDataSource getMessageDataSource(BStruct entityStruct) {
        return entityStruct.getNativeData("message_datasource") != null ? (MessageDataSource)entityStruct.getNativeData("message_datasource") : null;
    }

    public static void addMessageDataSource(BStruct entityStruct, MessageDataSource messageDataSource) {
        entityStruct.addNativeData("message_datasource", (Object)messageDataSource);
    }

    public static BlobDataSource constructBlobDataSource(BStruct entityStruct) throws IOException {
        Channel byteChannel = EntityBodyHandler.getByteChannel(entityStruct);
        if (byteChannel == null) {
            return null;
        }
        byte[] byteData = MimeUtil.getByteArray(byteChannel.getInputStream());
        byteChannel.close();
        return new BlobDataSource(byteData);
    }

    public static BJSON constructJsonDataSource(BStruct entityStruct) {
        try {
            Channel byteChannel = EntityBodyHandler.getByteChannel(entityStruct);
            if (byteChannel == null) {
                return null;
            }
            BJSON jsonData = new BJSON(byteChannel.getInputStream());
            byteChannel.close();
            return jsonData;
        }
        catch (IOException e) {
            throw new BallerinaIOException("Error occurred while closing connection", (Throwable)e);
        }
    }

    public static BXML constructXmlDataSource(BStruct entityStruct) {
        try {
            Channel byteChannel = EntityBodyHandler.getByteChannel(entityStruct);
            if (byteChannel == null) {
                throw new BallerinaIOException("Empty xml payload");
            }
            BXML xmlContent = XMLUtils.parse((InputStream)byteChannel.getInputStream());
            byteChannel.close();
            return xmlContent;
        }
        catch (IOException e) {
            throw new BallerinaIOException("Error occurred while closing the channel", (Throwable)e);
        }
    }

    public static StringDataSource constructStringDataSource(BStruct entityStruct) {
        try {
            Channel byteChannel = EntityBodyHandler.getByteChannel(entityStruct);
            if (byteChannel == null) {
                throw new BallerinaIOException("Payload is null");
            }
            String textContent = StringUtils.getStringFromInputStream((InputStream)byteChannel.getInputStream());
            byteChannel.close();
            return new StringDataSource(textContent);
        }
        catch (IOException e) {
            throw new BallerinaIOException("Error occurred while closing the channel", (Throwable)e);
        }
    }

    public static boolean checkEntityBodyAvailability(BStruct entityStruct) {
        return entityStruct.getNativeData("entity_byte_channel") != null || EntityBodyHandler.getMessageDataSource(entityStruct) != null || entityStruct.getNativeData("body_parts") != null;
    }

    static void setPartsToTopLevelEntity(BStruct entity, ArrayList<BStruct> bodyParts) {
        if (!bodyParts.isEmpty()) {
            BStructType typeOfBodyPart = bodyParts.get(0).getType();
            BStruct[] result = bodyParts.toArray(new BStruct[bodyParts.size()]);
            BRefValueArray partsArray = new BRefValueArray((BRefType[])result, (BType)typeOfBodyPart);
            entity.addNativeData("body_parts", (Object)partsArray);
        }
    }

    public static void populateBodyContent(BStruct bodyPart, MIMEPart mimePart) {
        bodyPart.addNativeData("entity_byte_channel", (Object)new MimeEntityWrapper(new EntityBodyChannel(mimePart.readOnce()), mimePart));
    }

    public static void writeByteChannelToOutputStream(BStruct entityStruct, OutputStream messageOutputStream) throws IOException {
        Channel byteChannel = EntityBodyHandler.getByteChannel(entityStruct);
        if (byteChannel != null) {
            MimeUtil.writeInputToOutputStream(byteChannel.getInputStream(), messageOutputStream);
            byteChannel.close();
        }
    }

    public static void decodeEntityBody(Context context, BStruct entityStruct, Channel byteChannel) {
        String contentType = MimeUtil.getContentTypeWithParameters(entityStruct);
        if (!MimeUtil.isNotNullAndEmpty(contentType) || !contentType.startsWith("multipart/")) {
            return;
        }
        MultipartDecoder.parseBody(context, entityStruct, contentType, byteChannel.getInputStream());
    }

    public static BRefValueArray getBodyPartArray(BStruct entityStruct) {
        return entityStruct.getNativeData("body_parts") != null ? (BRefValueArray)entityStruct.getNativeData("body_parts") : new BRefValueArray();
    }

    public static Channel getByteChannel(BStruct entityStruct) {
        return entityStruct.getNativeData("entity_byte_channel") != null ? (Channel)entityStruct.getNativeData("entity_byte_channel") : null;
    }
}

