/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.mime.util;

import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;
import org.ballerinalang.mime.util.EntityBodyHandler;
import org.ballerinalang.mime.util.MimeUtil;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BRefValueArray;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.runtime.message.BallerinaMessageDataSource;
import org.ballerinalang.runtime.message.MessageDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipartDataSource
extends BallerinaMessageDataSource {
    private static final Logger log = LoggerFactory.getLogger(MultipartDataSource.class);
    private BStruct parentEntity;
    private String boundaryString;
    private OutputStream outputStream;
    private static final String DASH_BOUNDARY = "--";
    private static final String CRLF_POST_DASH = "\r\n--";
    private static final String CRLF_PRE_DASH = "--\r\n";
    private static final String CRLF = "\r\n";
    private static final char COMMA = ',';
    private static final char COLON = ':';
    private static final char SPACE = ' ';

    public MultipartDataSource(BStruct entityStruct, String boundaryString) {
        this.parentEntity = entityStruct;
        this.boundaryString = boundaryString;
    }

    public void serializeData(OutputStream outputStream) {
        this.outputStream = outputStream;
        this.serializeBodyPart(outputStream, this.boundaryString, this.parentEntity);
    }

    private void serializeBodyPart(OutputStream outputStream, String parentBoundaryString, BStruct parentBodyPart) {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, Charset.defaultCharset()));
        BRefValueArray childParts = parentBodyPart.getNativeData("body_parts") != null ? (BRefValueArray)parentBodyPart.getNativeData("body_parts") : null;
        try {
            if (childParts == null) {
                return;
            }
            boolean isFirst = true;
            int i = 0;
            while ((long)i < childParts.size()) {
                BStruct childPart = (BStruct)childParts.get((long)i);
                if (isFirst) {
                    isFirst = false;
                    writer.write(DASH_BOUNDARY);
                } else {
                    writer.write(CRLF_POST_DASH);
                }
                writer.write(parentBoundaryString);
                writer.write(CRLF);
                this.checkForNestedParts(writer, childPart);
                this.writeBodyContent(outputStream, childPart);
                ++i;
            }
            this.writeFinalBoundaryString(writer, parentBoundaryString);
        }
        catch (IOException e) {
            log.error("Error occurred while writing body parts to outputstream", (Object)e.getMessage());
        }
    }

    private void checkForNestedParts(Writer writer, BStruct childPart) throws IOException {
        BRefValueArray nestedParts;
        String childBoundaryString = null;
        if (MimeUtil.isNestedPartsAvailable(childPart)) {
            childBoundaryString = MimeUtil.getNewMultipartDelimiter();
            BStruct mediaType = (BStruct)childPart.getRefField(0);
            BMap paramMap = mediaType.getRefField(0) != null ? (BMap)mediaType.getRefField(0) : new BMap();
            paramMap.put((Object)"boundary", (BValue)new BString(childBoundaryString));
            mediaType.setRefField(0, (BRefType)paramMap);
        }
        this.writeBodyPartHeaders(writer, childPart);
        if (childBoundaryString != null && (nestedParts = (BRefValueArray)childPart.getNativeData("body_parts")) != null && nestedParts.size() > 0L) {
            this.serializeBodyPart(this.outputStream, childBoundaryString, childPart);
        }
    }

    private void writeBodyPartHeaders(Writer writer, BStruct bodyPart) throws IOException {
        DefaultHttpHeaders httpHeaders;
        if (bodyPart.getNativeData("entity_headers") != null) {
            httpHeaders = (HttpHeaders)bodyPart.getNativeData("entity_headers");
        } else {
            httpHeaders = new DefaultHttpHeaders();
            bodyPart.addNativeData("entity_headers", (Object)httpHeaders);
        }
        String contentType = MimeUtil.getContentTypeWithParameters(bodyPart);
        httpHeaders.set(HttpHeaderNames.CONTENT_TYPE.toString(), (Object)contentType);
        String contentDisposition = MimeUtil.getContentDisposition(bodyPart);
        if (!contentDisposition.isEmpty()) {
            httpHeaders.set(HttpHeaderNames.CONTENT_DISPOSITION.toString(), (Object)contentDisposition);
        }
        if (bodyPart.getStringField(0) != null && !bodyPart.getStringField(0).isEmpty()) {
            httpHeaders.set("content-id", (Object)bodyPart.getStringField(0));
        }
        Iterator iterator = httpHeaders.iteratorAsString();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            writer.write((String)entry.getKey());
            writer.write(58);
            writer.write(32);
            writer.write((String)entry.getValue());
            writer.write(CRLF);
        }
        writer.write(CRLF);
        writer.flush();
    }

    private void writeFinalBoundaryString(Writer writer, String boundaryString) throws IOException {
        writer.write(CRLF_POST_DASH);
        writer.write(boundaryString);
        writer.write(CRLF_PRE_DASH);
        writer.flush();
    }

    private void writeBodyContent(OutputStream outputStream, BStruct bodyPart) throws IOException {
        MessageDataSource messageDataSource = EntityBodyHandler.getMessageDataSource(bodyPart);
        if (messageDataSource != null) {
            messageDataSource.serializeData(outputStream);
        } else {
            EntityBodyHandler.writeByteChannelToOutputStream(bodyPart, outputStream);
        }
    }
}

