/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.mime.util;

import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import org.ballerinalang.mime.util.MimeUtil;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BStringArray;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.jvnet.mimepull.Header;

public class HeaderUtil {
    public static BMap<String, BValue> getParamMap(String headerValue) {
        BMap<String, BValue> paramMap = null;
        if (headerValue.contains(";")) {
            HeaderUtil.extractValue(headerValue);
            List<String> paramList = Arrays.stream(headerValue.substring(headerValue.indexOf(";") + 1).split(";")).map(String::trim).collect(Collectors.toList());
            paramMap = HeaderUtil.validateParams(paramList) ? HeaderUtil.getHeaderParamBMap(paramList) : null;
        }
        return paramMap;
    }

    public static String getHeaderValue(String headerValue) {
        return HeaderUtil.extractValue(headerValue.trim());
    }

    private static String extractValue(String headerValue) {
        String value = headerValue.substring(0, headerValue.indexOf(";")).trim();
        if (value.isEmpty()) {
            throw new BallerinaException("invalid header value: " + headerValue);
        }
        return value;
    }

    private static boolean validateParams(List<String> paramList) {
        return paramList.size() != 1 || !paramList.get(0).isEmpty();
    }

    private static BMap<String, BValue> getHeaderParamBMap(List<String> paramList) {
        BMap paramMap = new BMap();
        for (String param : paramList) {
            if (param.contains("=")) {
                String[] keyValuePair = param.split("=");
                if (keyValuePair.length != 2 || keyValuePair[0].isEmpty()) {
                    throw new BallerinaException("invalid header parameter: " + param);
                }
                paramMap.put((Object)keyValuePair[0].trim(), (BValue)new BString(keyValuePair[1].trim()));
                continue;
            }
            paramMap.put((Object)param.trim(), null);
        }
        return paramMap;
    }

    static boolean isHeaderExist(List<String> headers) {
        return headers != null && headers.get(0) != null && !headers.get(0).isEmpty();
    }

    static HttpHeaders setBodyPartHeaders(List<? extends Header> bodyPartHeaders, HttpHeaders httpHeaders) {
        for (Header header : bodyPartHeaders) {
            httpHeaders.add(header.getName(), (Object)header.getValue());
        }
        return httpHeaders;
    }

    public static String getHeaderValue(BStruct bodyPart, String headerName) {
        if (bodyPart.getNativeData("entity_headers") != null) {
            HttpHeaders httpHeaders = (HttpHeaders)bodyPart.getNativeData("entity_headers");
            return httpHeaders.get(headerName);
        }
        return null;
    }

    static String appendHeaderParams(StringBuilder headerValue, BMap map) {
        Set keys;
        int index = 0;
        if (map != null && !map.isEmpty() && (keys = map.keySet()) != null && !keys.isEmpty()) {
            for (String key : keys) {
                BString paramValue = (BString)map.get((Object)key);
                if (index == keys.size() - 1) {
                    headerValue.append(key).append("=").append(paramValue.toString());
                    continue;
                }
                headerValue.append(key).append("=").append(paramValue.toString()).append(";");
                ++index;
            }
        }
        return headerValue.toString();
    }

    public static void overrideEntityHeader(BMap<String, BValue> entityHeaders, String headerName, String headerValue) {
        BStringArray valueArray = new BStringArray(new String[]{headerValue});
        entityHeaders.put((Object)headerName, (BValue)valueArray);
    }

    static void setContentTypeHeader(BStruct bodyPart, HttpHeaders entityHeaders) {
    }

    static void setContentDispositionHeader(BStruct bodyPart, BMap<String, BValue> entityHeaders) {
        String contentDisposition = MimeUtil.getContentDisposition(bodyPart);
        if (MimeUtil.isNotNullAndEmpty(contentDisposition)) {
            HeaderUtil.overrideEntityHeader(entityHeaders, HttpHeaderNames.CONTENT_DISPOSITION.toString(), contentDisposition);
        }
    }

    static void setContentIdHeader(BStruct bodyPart, BMap<String, BValue> entityHeaders) {
        String contentId = bodyPart.getStringField(0);
        if (MimeUtil.isNotNullAndEmpty(contentId)) {
            HeaderUtil.overrideEntityHeader(entityHeaders, "content-id", contentId);
        }
    }

    public static boolean isMultipart(String contentType) {
        return contentType != null && contentType.startsWith("multipart/");
    }

    public static BString extractBoundaryParameter(String contentType) {
        BMap<String, BValue> paramMap = HeaderUtil.getParamMap(contentType);
        if (paramMap != null) {
            return paramMap.get((Object)"boundary") != null ? (BString)paramMap.get((Object)"boundary") : null;
        }
        return null;
    }

    public static void setHeaderToEntity(BStruct entity, String key, String value) {
        DefaultHttpHeaders httpHeaders;
        if (entity.getNativeData("entity_headers") != null) {
            httpHeaders = (HttpHeaders)entity.getNativeData("entity_headers");
        } else {
            httpHeaders = new DefaultHttpHeaders();
            entity.addNativeData("entity_headers", (Object)httpHeaders);
        }
        httpHeaders.set(key, (Object)value);
    }

    public static BMap<String, BValue> getAllHeadersAsBMap(HttpHeaders headers) {
        BMap headerMap = new BMap();
        for (Map.Entry header : headers.entries()) {
            BStringArray valueArray;
            if (headerMap.keySet().contains(header.getKey())) {
                valueArray = (BStringArray)headerMap.get(header.getKey());
                valueArray.add(valueArray.size(), (String)header.getValue());
                continue;
            }
            valueArray = new BStringArray(new String[]{(String)header.getValue()});
            headerMap.put(header.getKey(), (BValue)valueArray);
        }
        return headerMap;
    }

    public static String getBaseType(BStruct entityStruct) throws MimeTypeParseException {
        String contentType = HeaderUtil.getHeaderValue(entityStruct, HttpHeaderNames.CONTENT_TYPE.toString());
        if (contentType != null) {
            return new MimeType(contentType).getBaseType();
        }
        return null;
    }
}

