/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.mime.nativeimpl;

import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BlockingNativeCallableUnit;
import org.ballerinalang.connector.api.ConnectorUtils;
import org.ballerinalang.mime.util.EntityBodyHandler;
import org.ballerinalang.mime.util.MimeUtil;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.nativeimpl.io.channels.base.Channel;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;

@BallerinaFunction(orgName="ballerina", packageName="mime", functionName="getByteChannel", receiver=@Receiver(type=TypeKind.STRUCT, structType="Entity", structPackage="ballerina.mime"), returnType={@ReturnType(type=TypeKind.STRUCT), @ReturnType(type=TypeKind.STRUCT)}, isPublic=true)
public class GetByteChannel
extends BlockingNativeCallableUnit {
    public void execute(Context context) {
        try {
            BStruct entityStruct = (BStruct)context.getRefArgument(0);
            BStruct byteChannelStruct = ConnectorUtils.createAndGetStruct((Context)context, (String)"ballerina.io", (String)"ByteChannel");
            Channel byteChannel = EntityBodyHandler.getByteChannel(entityStruct);
            if (byteChannel != null) {
                byteChannelStruct.addNativeData("channel", (Object)byteChannel);
                context.setReturnValues(new BValue[]{byteChannelStruct});
            } else if (EntityBodyHandler.getMessageDataSource(entityStruct) != null) {
                context.setReturnValues(new BValue[]{MimeUtil.createEntityError(context, "Byte channel is not available but payload can be obtain either as xml, json, string or blob type")});
            } else if (EntityBodyHandler.getBodyPartArray(entityStruct) != null && EntityBodyHandler.getBodyPartArray(entityStruct).size() != 0L) {
                context.setReturnValues(new BValue[]{MimeUtil.createEntityError(context, "Byte channel is not available since payload contains a set of body parts")});
            } else {
                context.setReturnValues(new BValue[]{MimeUtil.createEntityError(context, "Byte channel is not available as payload")});
            }
        }
        catch (Throwable e) {
            context.setReturnValues(new BValue[]{MimeUtil.createEntityError(context, "Error occurred while constructing byte channel from entity body : " + e.getMessage())});
        }
    }
}

