/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.mime.nativeimpl;

import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BlockingNativeCallableUnit;
import org.ballerinalang.mime.util.EntityBodyHandler;
import org.ballerinalang.mime.util.MimeUtil;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BBlob;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.runtime.message.BlobDataSource;
import org.ballerinalang.runtime.message.MessageDataSource;

@BallerinaFunction(orgName="ballerina", packageName="mime", functionName="getBlob", receiver=@Receiver(type=TypeKind.STRUCT, structType="Entity", structPackage="ballerina.mime"), returnType={@ReturnType(type=TypeKind.BLOB), @ReturnType(type=TypeKind.STRUCT)}, isPublic=true)
public class GetBlob
extends BlockingNativeCallableUnit {
    public void execute(Context context) {
        BlobDataSource result = null;
        try {
            BStruct entityStruct = (BStruct)context.getRefArgument(0);
            MessageDataSource messageDataSource = EntityBodyHandler.getMessageDataSource(entityStruct);
            if (messageDataSource != null) {
                result = (BlobDataSource)messageDataSource;
            } else {
                result = EntityBodyHandler.constructBlobDataSource(entityStruct);
                EntityBodyHandler.addMessageDataSource(entityStruct, (MessageDataSource)result);
                entityStruct.addNativeData("entity_byte_channel", null);
            }
        }
        catch (Throwable e) {
            context.setReturnValues(new BValue[]{MimeUtil.createEntityError(context, "Error occurred while extracting blob data from entity : " + e.getMessage())});
        }
        context.setReturnValues(new BValue[]{new BBlob(result != null ? result.getValue() : new byte[]{})});
    }
}

