/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.mime.util;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.util.internal.PlatformDependent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Set;
import javax.activation.MimeType;
import javax.activation.MimeTypeParameterList;
import javax.activation.MimeTypeParseException;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BLangVMStructs;
import org.ballerinalang.mime.util.HeaderUtil;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.util.codegen.PackageInfo;
import org.ballerinalang.util.codegen.StructInfo;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MimeUtil {
    private static final Logger log = LoggerFactory.getLogger(MimeUtil.class);

    public static String getBaseType(BStruct entity) {
        BStruct mediaType;
        if (entity.getRefField(0) != null && (mediaType = (BStruct)entity.getRefField(0)) != null) {
            return mediaType.getStringField(0) + "/" + mediaType.getStringField(1);
        }
        return null;
    }

    public static String getContentTypeWithParameters(BStruct entity) {
        if (entity.getRefField(0) == null) {
            return HeaderUtil.getHeaderValue(entity, HttpHeaderNames.CONTENT_TYPE.toString());
        }
        BStruct mediaType = (BStruct)entity.getRefField(0);
        String contentType = mediaType.getStringField(0) + "/" + mediaType.getStringField(1);
        if (mediaType.getRefField(0) != null) {
            BMap map;
            BMap bMap = map = mediaType.getRefField(0) != null ? (BMap)mediaType.getRefField(0) : null;
            if (map != null && !map.isEmpty()) {
                contentType = contentType + ";";
                return HeaderUtil.appendHeaderParams(new StringBuilder(contentType), map);
            }
        }
        return contentType;
    }

    public static void setContentType(BStruct mediaType, BStruct entityStruct, String contentType) {
        BStruct mimeType = MimeUtil.parseMediaType(mediaType, contentType);
        if (contentType == null) {
            mimeType.setStringField(0, "application");
            mimeType.setStringField(1, "octet-stream");
        }
        entityStruct.setRefField(0, (BRefType)mimeType);
    }

    public static BStruct parseMediaType(BStruct mediaType, String contentType) {
        try {
            if (contentType != null) {
                MimeType mimeType = new MimeType(contentType);
                mediaType.setStringField(0, mimeType.getPrimaryType());
                mediaType.setStringField(1, mimeType.getSubType());
                if (mimeType.getSubType() != null && mimeType.getSubType().contains("+")) {
                    mediaType.setStringField(2, mimeType.getSubType().substring(mimeType.getSubType().lastIndexOf("+") + 1));
                }
                MimeTypeParameterList parameterList = mimeType.getParameters();
                Enumeration keys = parameterList.getNames();
                BMap parameterMap = new BMap();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    String value = parameterList.get(key);
                    parameterMap.put((Object)key, (BValue)new BString(value));
                }
                mediaType.setRefField(0, (BRefType)parameterMap);
            }
        }
        catch (MimeTypeParseException e) {
            throw new BallerinaException("Error while parsing Content-Type value: " + e.getMessage());
        }
        return mediaType;
    }

    public static void setContentDisposition(BStruct contentDisposition, BStruct bodyPart, String contentDispositionHeaderWithParams) {
        MimeUtil.populateContentDispositionObject(contentDisposition, contentDispositionHeaderWithParams);
        bodyPart.setRefField(1, (BRefType)contentDisposition);
    }

    public static void populateContentDispositionObject(BStruct contentDisposition, String contentDispositionHeaderWithParams) {
        if (MimeUtil.isNotNullAndEmpty(contentDispositionHeaderWithParams)) {
            String dispositionValue = contentDispositionHeaderWithParams.contains(";") ? HeaderUtil.getHeaderValue(contentDispositionHeaderWithParams) : contentDispositionHeaderWithParams;
            contentDisposition.setStringField(1, dispositionValue);
            BMap<String, BValue> paramMap = HeaderUtil.getParamMap(contentDispositionHeaderWithParams);
            if (paramMap != null) {
                Set keys = paramMap.keySet();
                for (String key : keys) {
                    BString paramValue = (BString)paramMap.get((Object)key);
                    switch (key) {
                        case "filename": {
                            contentDisposition.setStringField(0, MimeUtil.stripQuotes(paramValue.toString()));
                            break;
                        }
                        case "name": {
                            contentDisposition.setStringField(2, MimeUtil.stripQuotes(paramValue.toString()));
                            break;
                        }
                    }
                }
                paramMap.remove((Object)"filename");
                paramMap.remove((Object)"name");
            }
            contentDisposition.setRefField(0, paramMap);
        }
    }

    public static String getContentDisposition(BStruct entity) {
        BStruct contentDispositionStruct;
        StringBuilder dispositionBuilder = new StringBuilder();
        if (entity.getRefField(1) != null && (contentDispositionStruct = (BStruct)entity.getRefField(1)) != null) {
            String disposition = contentDispositionStruct.getStringField(1);
            if (disposition == null || disposition.isEmpty()) {
                String contentType = MimeUtil.getBaseType(entity);
                if (contentType != null && contentType.equals("multipart/form-data")) {
                    dispositionBuilder.append("form-data");
                }
            } else {
                dispositionBuilder.append(disposition);
            }
            if (!dispositionBuilder.toString().isEmpty()) {
                dispositionBuilder = MimeUtil.convertDispositionObjectToString(dispositionBuilder, contentDispositionStruct);
            }
        }
        return dispositionBuilder.toString();
    }

    public static StringBuilder convertDispositionObjectToString(StringBuilder dispositionBuilder, BStruct contentDispositionStruct) {
        String name = contentDispositionStruct.getStringField(2);
        String fileName = contentDispositionStruct.getStringField(0);
        if (MimeUtil.isNotNullAndEmpty(name)) {
            MimeUtil.appendSemiColon(dispositionBuilder).append("name").append("=").append(MimeUtil.includeQuotes(name)).append(";");
        }
        if (MimeUtil.isNotNullAndEmpty(fileName)) {
            MimeUtil.appendSemiColon(dispositionBuilder).append("filename").append("=").append(MimeUtil.includeQuotes(fileName)).append(";");
        }
        if (contentDispositionStruct.getRefField(0) != null) {
            BMap map = (BMap)contentDispositionStruct.getRefField(0);
            HeaderUtil.appendHeaderParams(MimeUtil.appendSemiColon(dispositionBuilder), map);
        }
        if (dispositionBuilder.toString().endsWith(";")) {
            dispositionBuilder.setLength(dispositionBuilder.length() - 1);
        }
        return dispositionBuilder;
    }

    private static StringBuilder appendSemiColon(StringBuilder disposition) {
        if (!disposition.toString().endsWith(";")) {
            disposition.append(";");
        }
        return disposition;
    }

    public static void setContentLength(BStruct entityStruct, int length) {
        entityStruct.setIntField(0, (long)length);
    }

    public static BStruct extractEntity(BStruct httpMessageStruct) {
        Object isEntityBodyAvailable = httpMessageStruct.getNativeData("is_byte_channel_set");
        if (isEntityBodyAvailable == null || !((Boolean)isEntityBodyAvailable).booleanValue()) {
            return null;
        }
        return (BStruct)httpMessageStruct.getNativeData("message_entity");
    }

    static String writeToTemporaryFile(InputStream inputStream, String fileName) {
        OutputStream outputStream = null;
        try {
            File tempFile = File.createTempFile(fileName, ".tmp");
            outputStream = new FileOutputStream(tempFile.getAbsolutePath());
            MimeUtil.writeInputToOutputStream(inputStream, outputStream);
            inputStream.close();
            outputStream.flush();
            outputStream.close();
            String string = tempFile.getAbsolutePath();
            return string;
        }
        catch (IOException e) {
            throw new BallerinaException("Error while writing the payload info into a temp file: " + e.getMessage());
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                log.error("Error occured while closing outputstream in writeToTemporaryFile", (Object)e.getMessage());
            }
        }
    }

    public static void writeInputToOutputStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int len;
        byte[] buffer = new byte[8192];
        while ((len = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, len);
        }
    }

    static byte[] getByteArray(InputStream input) throws IOException {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            int len;
            byte[] buffer = new byte[8192];
            while ((len = input.read(buffer)) != -1) {
                output.write(buffer, 0, len);
            }
            byte[] byArray = output.toByteArray();
            return byArray;
        }
    }

    public static boolean isNotNullAndEmpty(String textValue) {
        return textValue != null && !textValue.isEmpty();
    }

    public static String includeQuotes(String textValue) {
        if (!textValue.startsWith("\"")) {
            textValue = "\"" + textValue;
        }
        if (!textValue.endsWith("\"")) {
            textValue = textValue + "\"";
        }
        return textValue;
    }

    private static String stripQuotes(String textValue) {
        if (textValue.startsWith("\"")) {
            textValue = textValue.substring(1);
        }
        if (textValue.endsWith("\"")) {
            textValue = textValue.substring(0, textValue.length() - 1);
        }
        return textValue;
    }

    public static String getNewMultipartDelimiter() {
        return Long.toHexString(PlatformDependent.threadLocalRandom().nextLong());
    }

    static boolean isNestedPartsAvailable(BStruct bodyPart) {
        String contentTypeOfChildPart = MimeUtil.getBaseType(bodyPart);
        return contentTypeOfChildPart != null && contentTypeOfChildPart.startsWith("multipart/") && bodyPart.getNativeData("body_parts") != null;
    }

    public static BStruct createEntityError(Context context, String msg) {
        PackageInfo filePkg = context.getProgramFile().getPackageInfo("ballerina.mime");
        StructInfo entityErrInfo = filePkg.getStructInfo("EntityError");
        return BLangVMStructs.createBStruct((StructInfo)entityErrInfo, (Object[])new Object[]{msg});
    }

    public static BStruct getParserError(Context context, String errMsg) {
        PackageInfo errorPackageInfo = context.getProgramFile().getPackageInfo("ballerina.builtin");
        StructInfo errorStructInfo = errorPackageInfo.getStructInfo("error");
        BStruct parserError = new BStruct(errorStructInfo.getType());
        parserError.setStringField(0, errMsg);
        return parserError;
    }
}

