/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.mime.util;

import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import org.ballerinalang.bre.Context;
import org.ballerinalang.connector.api.ConnectorUtils;
import org.ballerinalang.mime.util.EntityBodyHandler;
import org.ballerinalang.mime.util.HeaderUtil;
import org.ballerinalang.mime.util.MimeUtil;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.jvnet.mimepull.MIMEConfig;
import org.jvnet.mimepull.MIMEMessage;
import org.jvnet.mimepull.MIMEPart;

public class MultipartDecoder {
    public static void parseBody(Context context, BStruct entity, String contentType, InputStream inputStream) {
        try {
            List<MIMEPart> mimeParts = MultipartDecoder.decodeBodyParts(contentType, inputStream);
            if (mimeParts != null && !mimeParts.isEmpty()) {
                MultipartDecoder.populateBallerinaParts(context, entity, mimeParts);
            }
        }
        catch (MimeTypeParseException e) {
            throw new BallerinaException("Error occurred while decoding body parts from inputstream " + e.getMessage());
        }
    }

    public static List<MIMEPart> decodeBodyParts(String contentType, InputStream inputStream) throws MimeTypeParseException {
        MimeType mimeType = new MimeType(contentType);
        MIMEMessage mimeMessage = new MIMEMessage(inputStream, mimeType.getParameter("boundary"), MultipartDecoder.getMimeConfig());
        return mimeMessage.getAttachments();
    }

    private static MIMEConfig getMimeConfig() {
        MIMEConfig mimeConfig = new MIMEConfig();
        mimeConfig.setMemoryThreshold(0x200000L);
        return mimeConfig;
    }

    private static void populateBallerinaParts(Context context, BStruct entity, List<MIMEPart> mimeParts) {
        ArrayList<BStruct> bodyParts = new ArrayList<BStruct>();
        for (MIMEPart mimePart : mimeParts) {
            BStruct partStruct = ConnectorUtils.createAndGetStruct((Context)context, (String)"ballerina.mime", (String)"Entity");
            BStruct mediaType = ConnectorUtils.createAndGetStruct((Context)context, (String)"ballerina.mime", (String)"MediaType");
            MultipartDecoder.populateBodyPart(context, mimePart, partStruct, mediaType);
            bodyParts.add(partStruct);
        }
        EntityBodyHandler.setPartsToTopLevelEntity(entity, bodyParts);
    }

    private static void populateBodyPart(Context context, MIMEPart mimePart, BStruct partStruct, BStruct mediaType) {
        partStruct.addNativeData("entity_headers", (Object)HeaderUtil.setBodyPartHeaders(mimePart.getAllHeaders(), (HttpHeaders)new DefaultHttpHeaders()));
        MultipartDecoder.populateContentLength(mimePart, partStruct);
        MultipartDecoder.populateContentId(mimePart, partStruct);
        MultipartDecoder.populateContentType(mimePart, partStruct, mediaType);
        List contentDispositionHeaders = mimePart.getHeader(HttpHeaderNames.CONTENT_DISPOSITION.toString());
        if (HeaderUtil.isHeaderExist(contentDispositionHeaders)) {
            BStruct contentDisposition = ConnectorUtils.createAndGetStruct((Context)context, (String)"ballerina.mime", (String)"ContentDisposition");
            MultipartDecoder.populateContentDisposition(partStruct, contentDispositionHeaders, contentDisposition);
        }
        EntityBodyHandler.populateBodyContent(partStruct, mimePart);
    }

    private static void populateContentDisposition(BStruct partStruct, List<String> contentDispositionHeaders, BStruct contentDisposition) {
        MimeUtil.setContentDisposition(contentDisposition, partStruct, contentDispositionHeaders.get(0));
    }

    private static void populateContentType(MIMEPart mimePart, BStruct partStruct, BStruct mediaType) {
        MimeUtil.setContentType(mediaType, partStruct, mimePart.getContentType());
    }

    private static void populateContentId(MIMEPart mimePart, BStruct partStruct) {
        partStruct.setStringField(0, mimePart.getContentId());
    }

    private static void populateContentLength(MIMEPart mimePart, BStruct partStruct) {
        List lengthHeaders = mimePart.getHeader(HttpHeaderNames.CONTENT_LENGTH.toString());
        if (HeaderUtil.isHeaderExist(lengthHeaders)) {
            MimeUtil.setContentLength(partStruct, Integer.parseInt((String)lengthHeaders.get(0)));
        } else {
            MimeUtil.setContentLength(partStruct, -1);
        }
    }
}

